# $Date: 1994/10/03 22:54:02 $ $Author: kraume $ $Revision: 1.2 $ #
#--
intlib::sqffTab(A) - computes the square-free factorization for a polynomial
with leading coefficient 1. It delivers a table where the index is the exponent 
of the square free factor.
K.O. Geddes, Algorithms for Computer Algebra, Algorithm 8.2
--#
intlib::sqffTab:= proc(A)
  local i,x,B,C,W,Y,Z,tab;
begin
  i:=1; x:=op(A,[2,1]);
  B:=diff(A,x); C:=intlib::gcdk_n(A,B);
  if C=poly(1,[x])
    then tab[1]:=A;
    else W:=intlib::sim(divide(A,C)[1]);
         Y:=intlib::sim(divide(B,C)[1]);
         Z:=intlib::sim(Y-diff(W,x));
         while not(iszero(Z)) do
           G:=intlib::gcdk_n(W,Z);
           tab[i]:=G;
           i:=i+1; 
           W:=intlib::sim(divide(W,G)[1]);
           Y:=intlib::sim(divide(Z,G)[1]);
           Z:=intlib::sim(Y-diff(W,x));
         end_while;
         tab[i]:=W;
  end_if;
  return(tab);
end_proc:
