# $Date: 1994/10/03 22:54:03 $ $Author: kraume $ $Revision: 1.2 $ #
#--
intlib::sub() - is a remember table of the substitution equations for sin,cos,..
--#
intlib::sub:=proc()
  local i;
# global f; #
begin args(i) $ i=1..args(0)-1 end_proc:

# remember table for use with exp and ln #
intlib::sub(FAIL,Exp)        :=proc()
begin
if domtype(f)=DOM_LIST then return([args()]);
                       else return(f);
end_if; end_proc:
intlib::sub(hold(sin),Exp)   :=proc(x) begin 1/(2*I)*(exp(x*I)-exp(-x*I))
end_proc:
intlib::sub(hold(cos),Exp)   :=proc(x) begin 1/2*(exp(x*I)+exp(-x*I))          
end_proc:
intlib::sub(hold(asin),Exp)  :=proc(x) begin -I*ln(I*x+sqrt(1-x^2))            
end_proc:
intlib::sub(hold(acos),Exp)  :=proc(x) begin -I*ln(x+sqrt(x^2-1))              
end_proc:
intlib::sub(hold(tan),Exp)   :=proc(x) begin -I*(exp(x*I)^2-1)/(exp(x*I)^2+1)  
end_proc:
intlib::sub(hold(atan),Exp)  :=proc(x) begin -I*1/2*ln((1+I*x)/(1-I*x))        
end_proc:
intlib::sub(hold(sinh),Exp)  :=proc(x) begin 1/2*(exp(x)-exp(-x))              
end_proc:
intlib::sub(hold(cosh),Exp)  :=proc(x) begin 1/2*(exp(x)+exp(-x))              
end_proc:
intlib::sub(hold(tanh),Exp)  :=proc(x) begin (exp(x)^2-1)/(exp(x)^2+1)         
end_proc:
intlib::sub(hold(asinh),Exp) :=proc(x) begin ln(x+sqrt(x^2+1))                 
end_proc:
intlib::sub(hold(acosh),Exp) :=proc(x) begin ln(x+sqrt(x^2+1))                 
end_proc:
intlib::sub(hold(atanh),Exp) :=proc(x) begin 1/2*ln((1+x)/(1-x))               
end_proc:
intlib::sub(hold(cot),Exp)   :=proc(x) begin I*(exp(x*I)^2+1)/(exp(x*I)^2-1)   
end_proc:
intlib::sub(hold(acot),Exp)  :=proc(x) begin I*1/2*ln((x*I+1)/(x*I-1))         
end_proc:
intlib::sub(hold(coth),Exp)  :=proc(x) begin (exp(x)^2+1)/(exp(x)^2-1)         
end_proc:
intlib::sub(hold(acoth),Exp) :=proc(x) begin 1/2*ln((x+1)/(x-1))               
end_proc:
