# $Date: 1995/06/07 13:17:43 $ $Author: zimmerma $ $Revision: 1.6 $ #
#--
intlib::weaknorm(f,n) - computes for f in k[n] a polynomial P so that 
h:=f-P'/P is weakly normal
--#
intlib::weaknorm:=proc(f,n)
  local x,i,j,P,A,B;
# global k,k_sub,k_diff,k_ident; #
begin
  if n=nops(k) then return(1); end_if;
  f:=intlib::split2(f,n);
  if iszero(f[3]) then return(1); end_if;
  f[4]:=intlib::sqffTab(f[4]);
  f:=intlib::hermite(f,n); # f[3] is the numerator and f[4] is the denominator #
  if iszero(f[3]) then return(1); end_if;
  P:=expr(f[3])/expr(f[4]);
  if op(k[n],0)=hold(exp) then P:=P-k_ident[1]*k_diff[n]; end_if;
  x:=k_sub[n];
  j:=1;
  for i from n+1 to nops(k) do
    if op(k[i],0)=hold(ln) and contains(indets(op(k[i])),x)
      then j:=j+1;
           P:=P-k_ident[j]*k_diff[i];
    end_if;
  end_for;
  P:=poly(numer(P),k_sub);
  A:=array(1..nterms(P),1..j); B:=array(1..nterms(P));
  for s from 1 to nterms(P) do
    i:=poly(nthcoeff(P,s),[k_ident[1]]);
    for t from 1 to j-1 do
      A[s,t]:=coeff(i,1);
      i:=poly(coeff(i,0),[k_ident[t+1]]);
    end_for;
    A[s,j]:=coeff(i,1);
    B[s]:=-coeff(i,0);
  end_for;
  B:=intlib::linsys(A,B,hold(Std));
  if B=FAIL then return(FAIL); end_if;
  P:=1;
  j:=1;
  for i from n+1 to nops(k) do
    if op(k[i],0)=hold(ln) and contains(indets(op(k[i])),x)
      then j:=j+1;
           if type(B[j])=DOM_INT then if B[j]>0 then P:=P*op(k[i])^B[j]; end_if;
           end_if
    end_if;
  end_for;
  return(P);
end_proc:
