# $Date: 1994/05/31 13:21:27 $  $Author: linus $  $Revision: 1.1 $ #

# kg, 18/06/93 #

#++
isa::poly_of -- tests if a polynomial contains elements of a certain type

isa::poly_of(s, t [,a...])

s - polynomial
t - type (string or executable)
a - additional argument for executable (optional)

't' may be an executable object or a Domain. If 't' is an
executable it is mapped to each element of the polynomial and must
return TRUE if the element is of the appropriate type.
The otional arguments 'a' are handled as additional arguments
to 't'.

Examples:
>> isa::poly_of( poly(x^2 + 2/3*x + 3), DOM_RAT);
FALSE
>> isa::poly_of( poly(x^2 + 2/3*x + 3), isa::real);
TRUE
++#

isa::poly_of:= proc(p, t)
    local i, a;
begin
    if domtype(p) = DOM_POLY then
	if domtype(t) = DOM_DOMAIN then
	    if iszero(p) then return(bool(type(coeff(p)) = t)) end_if;
	    for i from 1 to nterms(p) do
		if type(nthcoeff(p,i)) <> t then return(FALSE) end_if
	    end_for
	else
	    a:= args(i) $ i=3..args(0);
	    if iszero(p) then return(t(coeff(p),a)) end_if;
	    for i from 1 to nterms(p) do
		if not t(nthcoeff(p,i),a) then return(FALSE) end_if
	    end_for
	end_if;
	return(TRUE)
    end_if;
    FALSE
end_proc:

