# series.mu--library for series expansions #

#++

User functions:

series -- return a Taylor/Laurent/Puiseux/generalized series expansion

++#

proc()
    local path;
begin

Series:=domain():
Series::name:="series":
Series::info:="Library 'series': series expansions":
Series::interface:={}:

path := pathname("SERIES"):

Puiseux:=domain():
Puiseux::name:="Puiseux":
gfun:=domain():
gfun::name:="gfun":
gfun::info:="Library Gfun: manipulation of holonomic functions and recurrences"
:
gfun::interface:={hold(diffeqtorec),hold(rattaylor)}:

Series::series:= loadproc(Series::series, path, "series"):
Puiseux::create:= loadproc(Puiseux::create, path, "laurent"):
Puiseux::frompoly:= loadproc(Puiseux::frompoly, path, "laurent"):
gfun::rattaylor:= loadproc(gfun::rattaylor, path, "gfun"):
gfun::diffeqtorec:= loadproc(gfun::diffeqtorec, path, "gfun"):
Puiseux::_power:= loadproc(Puiseux::_power, path, "laurent"):
Puiseux::ldegree:= loadproc(Puiseux::ldegree, path, "laurent"):
Puiseux::set_var:= loadproc(Puiseux::set_var, path, "laurent"):

# generalized series expansions #
gseries:= loadproc(gseries, path, "gseries"):

null():
end_proc():

