# #
# $Date: 1995/06/15 14:36:54 $  $Author: frankp $   $Revision: 1.45 $ #
# #
# frankp, 03/03/94 #

# linalg.mu  --  the linear algebra library #

proc()
    local path;
begin

    # force loading #
    loadlib("domains"):

    linalg := domain():
    linalg::name := "linalg":
    linalg::info := "Library 'linalg': the linear algebra package":
    linalg::interface := { hold(linearSolve), hold(gaussElim),
	hold(det), hold(rank), hold(concatMatrix),
	hold(stackMatrix), hold(swapCol), hold(swapRow),
	hold(nrows), hold(ncols), hold(dimen), hold(gaussJordan),
	hold(delRow), hold(delCol), hold(transpose),
	hold(row), hold(col), hold(sylvester),
	hold(setRow), hold(setCol), hold(nonZeros), hold(angle),
	hold(scalarProduct), hold(crossProduct), hold(trace),
	hold(expr2Matrix), hold(vectorDimen), hold(charMatrix),
	hold(charPolynomial), hold(addRow), hold(addCol),
	hold(multRow), hold(multCol), hold(adjoint),
	hold(freeSet), hold(factorQR), hold(onSystem),
	hold(ogSystem), hold(nullSpace), hold(normalize),
	hold(isOrthogonal), hold(grad), hold(divergence), hold(curl),
	hold(vectorPotential), hold(ogCoordTab), hold(isHermitian),
	hold(extractMatrix), hold(randomMatrix), hold(jacobian),
	hold(eigenValues), hold(isPosDef), hold(cholesky),
	hold(jordanForm), hold(eigenVectors) }:
 
    path := pathname("LINALG");

linalg::ogCoordTab:= loadproc( linalg::ogCoordTab, path, "ogsystab" ):
linalg::vectorPotential:= loadproc( linalg::vectorPotential, path, "vecpot" ):
linalg::grad:= loadproc( linalg::grad, path, "grad" ):
linalg::divergence:= loadproc( linalg::divergence, path, "diverge" ):
linalg::curl:= loadproc( linalg::curl, path, "curl" ):
linalg::isOrthogonal:= loadproc( linalg::isOrthogonal, path, "isorthog" ):
linalg::normalize:= loadproc( linalg::normalize, path, "normaliz" ):
linalg::VectorOf:= loadproc( linalg::VectorOf, path, "vectorof" ):
linalg::charMatrix:= loadproc( linalg::charMatrix, path, "charmat" ):
linalg::charPolynomial:= loadproc( linalg::charPolynomial, path, "charpoly" ):
linalg::vectorDimen:= loadproc( linalg::vectorDimen, path, "vectdim" ):
linalg::gaussElim:= loadproc( linalg::gaussElim, path, "gauselim" ):
linalg::gaussJordan:= loadproc( linalg::gaussJordan, path, "gausjord" ):
linalg::det:= loadproc( linalg::det, path, "det" ):
linalg::rank:= loadproc( linalg::rank, path, "rank" ):
linalg::adjoint:= loadproc( linalg::adjoint, path, "adjoint" ):
linalg::linearSolve:= loadproc( linalg::linearSolve, path, "linsolve" ):
linalg::concatMatrix:= loadproc( linalg::concatMatrix, path, "concat" ):
linalg::stackMatrix:= loadproc( linalg::stackMatrix, path, "stack" ):
linalg::swapCol:= loadproc( linalg::swapCol, path, "swapcol" ):
linalg::swapRow:= loadproc( linalg::swapRow, path, "swaprow" ):
linalg::transpose:= loadproc( linalg::transpose, path, "transpos" ):
linalg::dimen:= loadproc( linalg::dimen, path, "dimen" ):
linalg::nrows:= loadproc( linalg::nrows, path, "nrows" ):
linalg::ncols:= loadproc( linalg::ncols, path, "ncols" ):
linalg::row:= loadproc( linalg::row, path, "row" ):
linalg::col:= loadproc( linalg::col, path, "col" ):
linalg::addRow:= loadproc( linalg::addRow, path, "addrow" ):
linalg::addCol:= loadproc( linalg::addCol, path, "addcol" ):
linalg::multRow:= loadproc( linalg::multRow, path, "mulrow" ):
linalg::multCol:= loadproc( linalg::multCol, path, "mulcol" ):
linalg::delRow:= loadproc( linalg::delRow, path, "delrow" ):
linalg::delCol:= loadproc( linalg::delCol, path, "delcol" ):
linalg::setRow:= loadproc( linalg::setRow, path, "setrow" ):
linalg::setCol:= loadproc( linalg::setCol, path, "setcol" ):
linalg::sylvester:= loadproc( linalg::sylvester, path, "sylv" ):
linalg::nonZeros:= loadproc( linalg::nonZeros, path, "nnz" ):
linalg::angle:= loadproc( linalg::angle, path, "angle" ):
linalg::crossProduct:= loadproc( linalg::crossProduct, path, "crossmul" ):
linalg::scalarProduct:= loadproc( linalg::scalarProduct, path, "scmult" ):
linalg::trace:= loadproc( linalg::trace, path, "trace" ):
linalg::expr2Matrix:= loadproc( linalg::expr2Matrix, path, "expr2mat" ):
linalg::freeSet:= loadproc( linalg::freeSet, path, "freeset" ):
linalg::factorQR:= loadproc( linalg::factorQR, path, "factorqr" ):
linalg::onSystem:= loadproc( linalg::onSystem, path, "onset" ):
linalg::ogSystem:= loadproc( linalg::ogSystem, path, "ogset" ):
linalg::nullSpace:= loadproc( linalg::nullSpace, path, "nulspace" ):
linalg::isHermitian:= loadproc( linalg::isHermitian, path, "isherm" ):
linalg::extractMatrix:= loadproc( linalg::extractMatrix, path, "extrmatr" ):
linalg::randomMatrix:= loadproc( linalg::randomMatrix, path, "randmat" ):
linalg::jacobian:= loadproc( linalg::jacobian, path, "jacobian" ):
linalg::eigenValues:= loadproc( linalg::eigenValues, path, "eigenval" ):
linalg::cholesky:= loadproc( linalg::cholesky, path, "cholesky" ):
linalg::isPosDef:= loadproc( linalg::isPosDef, path, "isposdef" ):
linalg::jordanForm:= loadproc( linalg::jordanForm, path, "jordan" ):
linalg::eigenVectors:= loadproc( linalg::eigenVectors, path, "eigenvec") :

    null()
end_proc():

# end of file #
