proc()
    local    path;
begin
    plotlib:=domain():
    plotlib::name:="plotlib":
    plotlib::info:="Library 'plotlib': Library routines for two- and three-dimensional plots.":
    plotlib::interface:={hold(cylindricalplot), hold(fieldplot),
                         hold(implicitplot), hold(polarplot), hold(sphericalplot),
                         hold(xrotate), hold(yrotate)}:

    path:= pathname("PLOTLIB"):

    plotlib::cylindricalplot := loadproc(plotlib::cylindricalplot, path, "pl_cylin"):
    plotlib::fieldplot       := loadproc(plotlib::fieldplot,       path, "pl_field"):
    plotlib::implicitplot    := loadproc(plotlib::implicitplot,    path, "implicit"):
    plotlib::polarplot       := loadproc(plotlib::polarplot,       path, "pl_polar"):
    plotlib::sphericalplot   := loadproc(plotlib::sphericalplot,   path, "pl_spher"):
    plotlib::vector          := loadproc(plotlib::vector,          path, "pl_vecto"):
    plotlib::xrotate         := loadproc(plotlib::xrotate,         path, "pl_xrota"):
    plotlib::yrotate         := loadproc(plotlib::yrotate,         path, "pl_yrota"):

    null():

end_proc():

