# #
# $Date: 1995/06/11 14:56:03 $  $Author: frankp $   $Revision: 1.17 $ #
# #
# frankp, 29/07/94 #

#++
  angle.mu

    linalg::angle(u,v) -- computes the angle between u and v where
			  u and v are vectors over the same coeffRing.

    The coefficient ring of the vectors has to provide the method
    'norm', which result for any element has to be a number.
    'linalg::angle' returns FAIL if such a method does not exists.

    The angle x between two vectors u and v is defined by

                ( u * v )
	x = acos(-------),
                (|u| |v|)
    
    where '*' meens the scalar product of two vectors defined by 
    linalg::scalarProduct and |.| meens the 2-norm of a vector
    defined by method "norm".

    The user has to make sure that the argument of acos is
    valid (see also: linalg::scalarProduct).
++#

linalg::angle := proc(u,v)
    name linalg::angle;
    local n1, n2;
begin
    if testargs() then
        if args(0) <> 2 then error("wrong no of args") end_if;
	if not testtype( u,linalg::VectorOf(Type::AnyType) ) then
	    error("expecting two vectors")
	end_if;
	if not testtype(v,linalg::VectorOf(u::coeffRing,max(op(u::dimen(u)))))
	then
	    error("expecting two vectors")
	end_if
    end_if;

    n1 := u::norm( u,2 );
    if n1 = FAIL then return( FAIL ) end_if;
    n2 := v::norm( v,2 );
    if iszero(n1) or iszero(n2) then
	error("angle is undefined")
    end_if;

    acos( linalg::scalarProduct(u,v) / n1 / n2 )
end_proc:

# end of file #
