# #
# $Date: 1995/02/07 14:48:35 $  $Author: frankp $   $Revision: 1.9 $ #
# #
# frankp, 1/08/94 #

#++
  delrow.mu

     linalg::delRow(A,p)           -- delete row p of A
     linalg::delRow(A,i..j)        -- delete rows i to j of A
     linalg::delCol(A,[i1,i2,...]) -- delete rows i1,i2,... of A
++#

linalg::delRow := proc(A,p)
    name linalg::delRow;
    local r;
begin
    if testargs() then
	if args(0) <> 2 then error("wrong no of args") end_if;
	if A::hasProp( MatrixCat ) <> TRUE then
	    error("expecting a matrix")
	end_if;
	r := op( A::dimen(A),1 );
	if testtype( p,Type::PosInt ) then
	    if p > r then
		error("index out of range")
	    end_if
	elif type(p) = "_range" then
	    if not testtype( op(p,1),Type::PosInt )
	    or not testtype( op(p,2),Type::PosInt )
	    then
		error("expecting range of positive integers")
	    end_if;
	    if op(p,1) > r or op(p,2) > r then
		error("range larger than upper matrix bound")
	    end_if
        elif testtype(p,Type::ListOf(Type::PosInt,1)) then
            if max(op(p)) > r then
                error("indices in list larger than upper matrix bound")
            end_if
	else
	    error("expecting an integer or range of integer")
	end_if
    end_if;

    if type(p) = "_range" then
	if op(p,1) > op(p,2) then return( A ) end_if;
	if op(p,2) - op(p,1) = op( A::dimen(A),1 ) - 1 then
	    return( NIL )
	end_if; 

	for r from op(p,1) to op(p,2) do	
            A := A::delRow(A,op(p,1))
	end_for;
    elif domtype(p) = DOM_LIST then
        p := sort(p,_not@_less);
        for r in p do
            A := A::delRow(A,r);
            if domtype(A) = DOM_IDENT then break end_if
        end_for;
        if domtype(A) = DOM_IDENT then NIL else A end_if
    else
	A::delRow(A,p)
    end_if
end_proc:

# end of file #
