# #
# $Date: 1995/02/07 12:37:13 $  $Author: frankp $   $Revision: 1.13 $ #
# #
# frankp, 21/02/94 #

#++
  gausselim.mu

    linalg::gaussElim  --  two-step fraction-free Gaussian elimination

    gaussElim(A)     - returns A in upper triangular form
    gaussElim(A,All) - returns [A,rank(A),det(A)] where A is in
		       upper triangular form
++#

linalg::gaussElim := proc(A)
    name linalg::gaussElim;
begin
    if testargs() then
	if args(0) < 1 or args(0) > 2 then 
	    error("wrong no of args")
	end_if;
	if A::hasProp( MatrixCat ) <> TRUE then
	    error("expecting a matrix")
	end_if;
        if not (A::coeffRing)::hasProp( IntegralDomain ) then
            error("expecting matrix over an integral domain")
        end_if;
	if args(0) = 2 then
	    if args(2) <> hold(All) then
		error("expecting 'All' as option")
	    end_if
	end_if
    end_if;
    
    if args(0) = 2 then A::gaussElim(A) else op( A::gaussElim(A),1 ) end_if
end_proc:

# end of file #
