# #
# $Date: 1995/06/16 13:39:57 $  $Author: frankp $   $Revision: 1.7.2.1 $ #
# #
# frankp, 2/03/94 #

#++
  gausjord.mu

	linalg::gaussJordan  --  computes the gauss-jordan elimination

	gaussJordan(A)     - returns A in upper triangular form
	gaussJordan(A,All) - returns [A,rank(A),det(A)], where A
		             is in upper triangular form
++#

linalg::gaussJordan := proc(A)
    name linalg::gaussJordan;
    local R, t, i, j, k, ns, de, isfield, Rmult, Riszero,
	  Rplus, Rnegate, T, Rzero, d;
begin
    if testargs() then
	if args(0) < 1 or args(0) > 2 then
	    error("wrong no of args")
	end_if;
	if A::hasProp( MatrixCat ) <> TRUE then
	    error("expecting a matrix")
	end_if;
	if not (A::coeffRing)::hasProp( IntegralDomain ) then
	    error("expecting a matrix over an integral domain")
	end_if;
	if args(0) = 2 then
	    if args(2) <> hold(All) then
	        error("expecting 'All' as option")
	    end_if
	end_if
    end_if;
  
    R := A::coeffRing;
    T := A::gaussElim(A);
    A := op(T,1);

    Rplus := R::_plus;
    Rnegate := R::negate;
    Rmult := R::_mult;
    Riszero := R::iszero;
    Rzero := R::zero;
    isfield := R::hasProp( Field );

    ns := [];
    t := [];
    d := A::dimen(A);
    j := 1;
    for i from 1 to d[2] do
	if j > d[1] then break end_if;
	if Riszero(A[j,i]) then ns := ns.[i]
	else t := t.[[j,i]]; j := j + 1;
	end_if
    end_for;
    (ns := ns.[k]) $ k=i..d[2]; # case r < c #
    de := []; # sort descending #
    for i from nops(t) downto 1 do de := de.[t[i]] end_for;

    for k in de do
	d := A[k[1],k[2]];
	if isfield then
	    t := R::divex;
	    for j in ns do A[k[1],j] := t(A[k[1],j],d) end_for;
	    t := R::one;
	    A[k[1],k[2]] := t; d := t
	end_if;	
	de[1] := NIL;
	for i in de do
	    t := Rnegate(A[i[1],k[2]]);
	    for j in ns do
		if not Riszero(A[k[1],j]) then
		    A[i[1],j] := Rplus(
			Rmult(A[i[1],j],d), Rmult( A[k[1],j],t )
		    )
		end_if
	    end_for;
	    if not Riszero(A[k[1],i[2]]) then
		A[i[1],i[2]] := Rmult(A[i[1],i[2]],t)
	    end_if;
	    A[i[1],k[2]] := Rzero
        end_for
    end_for;

    if args(0) = 2 then [A,T[2],T[3]] else A end_if
end_proc:

# end of file #
