# #
# $Date: 1995/05/31 20:57:01 $  $Author: frankp $   $Revision: 1.20 $ #
# #
# frankp, 29/07/94 #

#++
  scmult.mu

    	linalg::scalarProduct(u,v) -- returns the Euclidian scalar product
				      of u and v where u and v are
				      vectors over the same coeffRing. 

	The Euclidian scalar product of two vectors is defined by

	    u[1]*conjugate(v[1]) + u[2]*conjugate(v[2]) + ...

	If the coeffRing of u and v does not provide a method
	"conjugate" (which must return the complex conjugate
	of an expression) then the sum

	    u[1]*v[1] + u[2]*v[2] + ...

	is computed.
++#

linalg::scalarProduct := proc(u,v)
    name linalg::scalarProduct;
    local R;
begin
    if testargs() then
	if args(0) <> 2 then
	    error("wrong no of args")
	end_if;
	if not testtype( u,linalg::VectorOf(Type::AnyType) ) then
	    error("expecting two vectors")
	end_if;
	if not testtype(v,linalg::VectorOf(u::coeffRing,max(op(u::dimen(u))))) 
	then
	    error("vectors are not compatibel")
	end_if
    end_if;

    R := u::coeffRing;
    if R::conjugate <> FAIL then 
	R::_plus( 
	  R::_mult(u[i],R::conjugate(v[i])) 
	      $ hold(i)=1..max(op(u::dimen(u))
	  )
	)
    else 
	R::_plus( R::_mult( u[i],v[i] ) $ hold(i)=1..max(op(u::dimen(u))) )
    end_if
end_proc:

# end of file #
