# $Date: 1995/04/05 07:14:23 $ $Author: kg $ $Revision: 1.7 $ #

# kg, 13/01/95 #

#++
misc::subsFreeVars -- substitute only free variables

misc::subsFreeVars(ex [, o=n...] [,Unsimplified])

ex, o, n     - expressions
Unsimplified - option

misc::subsFreeVars(ex,...) works similar to subs(ex,...) but tries to
substitute free variables only, ie. formal parameters and local variables of
procedures are not substituted even if they are left hand sides of the
substitution equations.

Substitutions inside of function environments and domains are also not
made because most often the user don't want them to occure and often they
may cause infinite recursions if a domain is defined recursively. (subs
changes a domain D if it is the 0-operand of a domain element created by
new(D,...) and has no method "subs".) 
++#

misc::subsFreeVars:= proc(ex)
    local doSubs, unsimp, subsProc, a, i;
begin
    if args(0) = 1 then return(args(1)) end_if;
    if args(args(0)) = hold(Unsimplified) then 
    	if args(0) = 2 then return(args(1)) end_if;
    	a:= [args(i) $ i=2..(args(0)-1)];
    	unsimp:= hold(Unsimplified)
    else
    	a:= [args(i) $ i=2..args(0)];
        unsimp:= null()
    end_if;
    
    if testargs() then
    	if args(0) < 2 then error("wrong no of args") end_if;
    	if {op(map(a, type))} <> {"_equal"} then
    	    error("illegal substitution equation")
    	end_if
    end_if;

    doSubs:= proc(e) local i,l,a;
    begin
	if args(0) = 1 then return(args(1)) end_if;
	case domtype(args(1))
        of DOM_FUNC_ENV do
	of DOM_DOMAIN do
	    args(1);
    	    break;
    	
	of DOM_EXPR do
            l:=args(1);
    	    subsop(args(1), (i=doSubs(op(args(1),i), args(2)))
			    $ hold(i)=0..nops(args(1)), unsimp);
	    break;
	
	of DOM_PROC do
	    subsProc(args(1), args(2));
	    break;
	of DOM_RAT do
	of DOM_COMPLEX do
	    subs(args(1), op(args(2)), unsimp);
	    break;
	    
	otherwise
    	    if nops(args(1)) = 1 then
    	        subs(args(1), op(args(2)), unsimp)
    	    else
	        subsop(args(1), (i=doSubs(op(args(1),i), args(2)))
    			        $ hold(i)=1..nops(args(1)), unsimp)
            end_if
	end_case
    end_proc;

    subsProc:= 	proc(ex, a)
	local bound, i;
    begin
	bound:= {(if op(ex,1) = NIL then null() else
		      if type(op(ex,1)) = "_exprseq" then op(op(ex,1))
    		      else op(ex,1) end_if
    	          end_if),
		 (if op(ex,2) = NIL then null() else
    		      if type(op(ex,2)) = "_exprseq" then op(op(ex,2))
    		      else op(ex,2) end_if
    	          end_if)};
	a:= select(a, fun(not contains(bound, op(args(1),1))));
	if a = [] then
    	    ex
	else
    	    subsop(ex, (i=doSubs(op(ex,i), a)) $ i=4..5, unsimp)
	end_if
    end_proc;

    doSubs(ex, a)
end_proc:

# end of file #
