#-- 
 kamo, 20.2.95
 Blocking-Flow-Algorithmus mit Pumpprinzip.
 Verteilungsstrategie:
   Gebe "Uberschu"s an beliebige Nachfolgerknoten ab.
   Falls "Uberschu"s auf diese Weise nicht vollst"andig 
   abgebaut werden kann, gebe an Zulieferer zur"uck. 
   Blockiere Kanten "uber die R"uckfluss erfolgt.

   Achtung: Das Ergebnis ist ein blockierender Fluss.
   Entspricht im wesentlichen dem Algorithmus von Shiloach & Vishkin, 1982.
--#

Network::blockflow:= proc(N,q,s)
local schritt, blocking_flow, V,ED,EDpre,EDpost,up,Vd,s1,
block,inflow,outflow,preflow,ownprint,i,j,Q;
begin

#--
 schritt - F"uhrt einen Zeitschritt aus
   Q - Liste der unbalancierten Knoten
--#
schritt := proc(Q)
local i,j,e,PP,v,abgabe;
begin
for i in Q do
	PP := inflow[i] - outflow[i];
	j := 1;
	v := op(EDpost[i],j);
	#--
	 Abgabe an Nachfolgeknoten
	--#
	while v <> FAIL and PP > 0 do
		e := [i,v];
		if not block[v] then
			abgabe := max(min(up[e] - preflow[e], PP), 0);
			preflow[e] := preflow[e] + abgabe;
			PP := PP-abgabe; 
			outflow[i] := outflow[i] + abgabe;
			inflow[v] := inflow[v] + abgabe;
		end_if;
		j := j+1;
		v := op(EDpost[i],j);
	end_while;
	if PP > 0 then
		#- "Uberschu"s kann nicht nach vorne abgebaut werden:
			Blockiere Knoten
		-#
		block[i] := TRUE;
	end_if;
	j := 1;
	v := op(EDpre[i],j);
	#--
	 Rueckgabe an Vorg"angerknoten
	--#
	while v <> FAIL and PP > 0 do 
		e := [v,i];
		abgabe := max(min(preflow[e], PP),0);
		preflow[e] := preflow[e] - abgabe;
		PP := PP - abgabe;
		inflow[i] := inflow[i] - abgabe;
		outflow[v] := outflow[v] - abgabe;
		j := j+1;
		v := op(EDpre[i],j);
	end_while;
end_for;
Q := []:
for i in Vd do
	if inflow[i] <> outflow[i] then
		Q := append(Q,i);
	end_if;
end_for;
Q;
end_proc:

#--
 F"uhrt Breitensuche aus. Untersucht, ob im reduzierten Netzwerk
 die Senke von der Quelle erreichbar ist.
 Liefert TRUE, falls Senke von Quelle erreichbar.
--#
blocking_flow := proc(q,s,EDpost, up, flow)
local i,j,e,set,Q;
begin
set := {q}:
Q := [q]:
while Q <> [] do
        i := Q[1]:
        Q[1] := NIL;
        for j in EDpost[i] do
                e := [i,j];
                if up[e] - flow[e] > 0 then
                        if contains(Q,j) = 0 then
                                Q := append(Q,j);
                                set := set union {j};
                                if j = s then
                                        return(FALSE);
                                end_if;
                        end_if;
                end_if;
        end_for;
end_while:
not contains(set,s);
end_proc:


   V := Network::Vertex(N);
   Vd := {op(V)} minus {q,s}:
   ED := Network::Edge(N);
   up := Network::ECapacity(N);
   EDpre := Network::Epre(N);
   EDpost := Network::Epost(N);

   inflow := table(V[i] = 0 $ i=1..nops(V));
   outflow := inflow;
   preflow := table(ED[i] = 0 $ i=1..nops(ED));

   Q := []:
   for i in EDpost[q] do
	preflow[[q,i]] := up[[q,i]];
	outflow[q] := outflow[q] + up[[q,i]];
	inflow[i] := up[[q,i]];
	Q := append(Q, i);
   end_for;

   block := table(op(V,j) = FALSE $ j=1..nops(V));

   Q := schritt(Q);
   while Q <> [] do
	Q := schritt(Q);
   end_while;

   #- zufluss  nach s -#
   i := NIL;
   s1 := _plus(preflow[[ EDpre[s][i],s]] $ i=1..nops( EDpre[s]));
   s1, preflow;
end_proc:
