#- 
 ChangeVertex - change the weight of one or several vertices in a network
 ChangeVertex(G,x,Vweight=n)
 ChangeVertex(G,[x1,..,xn], Vweight=[v1,..vn])
-#
Network::ChangeVertex := proc(G,v,vw)
local V,i,a,b,c,Vw,lhs,rhs;
begin
   if testargs() then
      if args(0) <> 3 then
	     error("Wrong number of arguments!")
      end_if;
      Network::graph_check(G);
      if not testtype(args(3), "_equal") then
	     error("Wrong vertex weights specification!");
      end_if;
   end_if;
   
   lhs := op(vw,1); rhs := op(vw,2);
   if lhs <> hold(Vweight) then
	   error("Vertex weight specification!")
   end_if;

   if testtype(v, DOM_LIST) then
	   #--
	   if not testtype(rhs, Type::ListOf(NUMERIC)) then
		  error("Non numeric vertex weights!");
	   end_if;
	   --#
	   if nops(v) <> nops(rhs) then
		  error("Length of lists must be equal!");
	   end_if;
	   V := Network::Vertex(G);
	   Vw := Network::VWeight(G);
	   for i from 1 to nops(rhs) do
	      if contains(V, v[i]) = 0 then
	          error("specified node isn't contained in the network!");
	      end_if;
		  Vw[v[i]] := rhs[i];
	   end_for;
   else
	   #--
	   if not testtype(rhs, NUMERIC) then
		   error("Non numeric vertex weight!");
	   end_if;
	   --#
	   V := Network::Vertex(G);
	   if contains(V, v) = 0 then
	          error("specified node isn't contained in the network!");
	   end_if;
	   Vw := Network::VWeight(G);
	   Vw[v] := rhs;
   end_if;
	
   new(Network, V, Network::Edge(G), Vw, Network::ECapacity(G), 
	 Network::EWeight(G), Network::Epost(G), Network::Epre(G));
end_proc:
