#-
 Complete - generate a complete network
 Complete(n)
 Paramters:
   n - non-negative integer
 Generates the complete network with n vertices
-#
Network::Complete := proc(n)
local i,j,f,V,Ed;
begin
  if testargs() then
    if args(0) <> 1 then
	error("Wrong number of arguments!");
    end_if;
    if not testtype(n, Type::PosInt) then
	error("Argument must be a positive integer");
    end_if;
  end_if;
  V := [$1..n];
  Ed := [([i,j] $ j=1..n) $ i=1..n];
  f := fun(bool(args(1)[1] <> args(1)[2]));
  Ed := select(Ed, f);
  Network(V, Ed);
end_proc:
