#- 
 Cycle - generates a cycle 
  Cycle(L)
  Parameters:
    L - list (of nodes)
  Cycle([v1,..,vn]) generates a cycle with the edges [v1,v2], [v2,v3], ... , [v(n-1),vn], [vn,v1].
-#
Network::Cycle := proc(L)
local Ed,i;
begin
  if testargs() then
     if args(0) <> 1 then
	error("Wrong number of arguments!");
     end_if;
     if not testtype(L, DOM_LIST) then
	error("Wrong argument type: list expected!");
     end_if;
   end_if;

   Ed := [[L[i],L[i+1]] $ i=1..(nops(L)-1)]:
   Ed := append(Ed, [L[nops(L)], L[1]]);
   Network(L, Ed);
end_proc:
