#- 
 MaxFlow - computes a maximal flow
 MaxFlow(G,q,s)
 Parameters:
   G - network
   q,s - vertices in G
 Computes a maximal flow from q to s in G.
 Uses Network::pp_fifo.
-#
Network::MaxFlow := proc(G,q,s)
local V, Ed, Ecap, Epo, Epr;
begin
  if testargs() then
   	if args(0) <> 3 then
	   error("Wrong number of arguments!");
   	end_if;
	Network::graph_check(G);
	if not Network::IsVertex(G,q) and not Network::IsVertex(G,s) then
    	   error("Specified vertices are not contained in network!");
    	end_if;
  end_if;
  V := Network::Vertex(G);
  Ed := Network::Edge(G);
  Ecap := Network::ECapacity(G);
  Epo := Network::Epost(G);
  Epr := Network::Epre(G);
  Network::pp_fifo(V, Ed, Ecap, Epo, Epr, q,s);
end_proc:
