 #--
 MinCost - minimal cost flow
 MinCost(G)
 Parameters:
   G - network
 Uses Network::relaxation
--#
Network::MinCost := proc(G)
local V, Vw, Ed, Ew, Ecap, Epo, Epr, f, i; 
begin
   if testargs() then
      if args(0) <> 1 then
         error("Wrong number of parameters!");
      end_if;
      Network::check_graph(G);
   end_if;
   V := Network::Vertex(G);
   Ed := Network::Edge(G);
   Vw := Network::VWeight(G);
   Ecap := Network::ECapacity(G);
   Ew := Network::EWeight(G);
   Epo := Network::Epost(G);
   Epr := Network::Epre(G);
   f := Network::relaxation(V, Ed, Vw, Ecap, Ew, Epo, Epr);  
   _plus(Ew[Ed[i]] * f[1][Ed[i]] $ i=1..nops(Ed)), f[1],f[2];
end_proc:
