#-
 OutDegree - vertex outdegrees of a network
 Out Degree(G)
 Out Degree(G,v)
 Out Degree(G, [v1,..,vn])
 Parameters:
   G - network
   v,v1,..,vn - nodes of G
--#
Network::OutDegree := proc(G)
local i,d,V,Epo;
begin
   if testargs() then
      if args(0) < 1 then
        error("Wrong number of arguments!"):
      end_if;
      Network::graph_check(G);
   end_if;
   V := Network::Vertex(G);
   Epo := Network::Epost(G);
  
   case args(0)
        of 1 do
           return(table(V[i] = nops(Network::Epost(G)[V[i]]) $ i=1..nops(V)));
        of 2 do
           if contains(V, args(2)) = 0 then
                error("Network doesn't contain specified node!");
           end_if;
           return(nops(Epo[args(2)]));
        otherwise
           d := table();
           for i from 2 to args(0) do 
              if contains(V, args(i)) = 0 then
                error("Network doesn't contain specified node!");
              end_if;
              d[args(i)] := nops(Epo[args(i)]);
           end_for;
           return(d);
   end_case;
end_proc:
