#-
 Random - generates a random network
 Random()
 Random(In, density, Kn)
 Parameters:
   In - Interval for number of nodes N ( In[1] <= N <= In[2])
   density - Density of graph: Number of edges = N^2 * density * 2
	     (all edges are bidirectional)
   Kn - Interval for edge capacities
 Generates a random network N and returns [N, source, sink].
 Random() = Random([10,20], 0.5, [1,10])
-#
Network::Random := proc(In, density, Kn)
local N,Ne,f,g,h,Edge,up;
begin
  if testargs() then
     if args(0) = 0 then  #- default values -#
	In := [5,10]; density := 1/2; Kn := [1,10];
     end_if;
     if args(0) <> 0 and args(0) <> 3 then 
	error("Wrong number of arguments!");
     end_if; 
     if not testtype(In, Type::ListOf(DOM_INT)) then
        error("Wrong node number interval!");
     end_if;
     if In[1] >= In[2] then
        error("Illegal node number interval!");
     end_if;
     if not testtype(density, NUMERIC) then
        error("Wrong density!");
     end_if;
     if density < 0 or density > 1 then
        error("Density must be between 0 and 1!");
     end_if;
     if not testtype(Kn, Type::ListOf(DOM_INT)) then
        error("Wrong edge capacity interval!");
     end_if;
     if Kn[1] > Kn[2] then
        error("Illegal capacity interval!");
     end_if;
  end_if;

  N := random(In[2] - In[1] + 1)() + In[1];
  f := random(1..N);
  g := random(Kn[1]..Kn[2]);
  Ne := trunc(density * N^2);
  Edge := [];
  up := [];
  for i from 1 to trunc(Ne/2) do 
     repeat
        u := f();
        repeat
           v := f();
        until u <> v end_repeat;
	TT := contains(Edge, [u,v]);
     until (contains(Edge, [u,v]) = 0) end_repeat;
     Edge := Edge.[[u,v],[v,u]];
     h := g();
     up := up.[h,h];
  end_for;
  [Network([$1..N], Edge, Capacity=up),1,N];
end_proc:

