#-
 relaxation - Relaxation Algorithm for solving minimal cost flow problem
    D.P. Bertsekas: 
    Linear Network Optimization, 
    MIT Press, Cambridge(Mass.)-London,1991
-#
Network::relaxation := proc(V, Ed, Vw, Ecap, Ew, Epo, Epr)
local e,i,flow,price,deficit,DD,a,f,L,S,Lh,v,j,pp,
      label,update_dd, flow_augmentation, price_change, relax_step;
begin

#-
 update_dd - computation of directional derivative
-#
update_dd := proc(S,Epo,Epr,Ew,Ecap,flow,price,deficit)
local sum, j,e, v, pp;
begin
sum := _plus((deficit[op(S,j)] $ j=1..nops(S)));
for v in S do
   for j in Epo[v] do 
	e := [v,j];
	pp := price[e[1]] - (Ew[e] + price[e[2]]);
	if pp = 0 then
	   if not contains(S,j) then
		sum := sum - (Ecap[e] - flow[e])
	   end_if
	end_if
   end_for;
   for j in Epr[v] do 
	e := [j,v];
	pp := price[e[1]] - (Ew[e] + price[e[2]]);
	if pp = 0 then
	   if not contains(S,j) then
		sum := sum - flow[e]; #- (flow[e] - low[e]) -#
	   end_if
	end_if
   end_for;
end_for;
sum;
end_proc:


#-
 flow_augmentation - increases flow along an augmenting path from i to j 
-#
flow_augmentation := proc(i,j,deficit,flow,Ecap)
local Pp, Pm, oplist, l,w,d;
begin
Pp := {}; Pm := {};
oplist := [deficit[i], -deficit[j]];
w := j;
while TRUE do
	l := label[w];
	if w = l[1] then
		# R"uckw"artskante, Fluss wird reduziert #
		Pm := Pm union {l};
		oplist := oplist.[flow[l]];  #- flow[l] - low[l] -#
		v := l[2];
	else
		# Vorw"artskante, Fluss wird erh"oht #
		Pp := Pp union {l};
		oplist := oplist.[Ecap[l] - flow[l]];
		v := l[1];
	end_if;
	if v = i then
		break
	end_if;
	w := v;
end_while;

if nops(oplist) > 0 then
   d := min(op(oplist));
else
   d := 0;
end_if;

userinfo(2, d,Pp,Pm);

for e in Pp do
	flow[e] := flow[e] + d;
	deficit[e[1]] := deficit[e[1]] - d;
	deficit[e[2]] := deficit[e[2]] + d
end_for;

for e in Pm do
	flow[e] := flow[e] - d;
	deficit[e[1]] := deficit[e[1]] + d;
	deficit[e[2]] := deficit[e[2]] - d
end_for;
flow,deficit;
end_proc:

#++
 price_change - price adaption
++#
price_change := proc(S,Epo,Epr,Ew,Ecap,price,deficit,flow)
local g,i,e,oplist,pp;
begin
oplist := [];
for i in S do 
	for j in Epo[i] do
		e := [i,j];
		if not contains(S,j) then
			pp := price[e[1]] - (Ew[e] + price[e[2]]);
			if pp = 0 then
				deficit[e[1]] := deficit[e[1]] + flow[e];
				deficit[e[2]] := deficit[e[2]] - flow[e];
				flow[e] := Ecap[e];
				deficit[e[1]] := deficit[e[1]] - flow[e];
				deficit[e[2]] := deficit[e[2]] + flow[e];
			elif flow[e] < Ecap[e] then
				oplist := oplist.[price[j] + Ew[e] - price[i]]
			end_if;
		end_if;
	end_for;
	for j in Epr[i] do
		e := [j,i];
		if not contains(S,j) then
			pp := price[e[1]] - (Ew[e] + price[e[2]]);
			if pp = 0 then
				deficit[e[1]] := deficit[e[1]] + flow[e];
				deficit[e[2]] := deficit[e[2]] - flow[e];
				flow[e] := 0; #- := low[e] -#
				deficit[e[1]] := deficit[e[1]] - flow[e];
				deficit[e[2]] := deficit[e[2]] + flow[e];
			elif 0 < flow[e] then #- low[e] < flow[e] -#
				oplist := oplist.[price[j] - Ew[e] - price[i]]
			end_if;
		end_if;
	end_for;
end_for;

if nops(oplist) > 0 then
   g := min(op(oplist));
else
   g := 0;
end_if;

for i in S do 
	price[i] := price[i] + g;
end_for;
flow,deficit,price;
end_proc:


relax_step := proc(v,Ed,Ecap,Ew,Epo,Epr,flow,deficit,price,DD)
local e,i,L,S,Lh,j,pp,label;
begin
      L := {v}; S := {};
      while TRUE do
	     if S = L then
		     price_change(S,Epo,Epr,Ew,Ecap,price,deficit,flow);
		     flow := %[1];
		     deficit := %2[2];
		     price := %3[3];
		     return(flow,deficit,price,DD);
	     else
		     i := op(L minus S, 1);
		     S := S union {i};
		     DD := update_dd(S,Epo,Epr,Ew,Ecap,flow,price,deficit);
	     end_if;
	     if DD > 0 then 
		     price_change(S,Epo,Epr,Ew,Ecap,price,deficit,flow);
		     flow := %[1];
		     deficit := %2[2];
		     price := %3[3];
		     return(flow,deficit,price,DD);
	     else
		     Lh := {};
		     for j in Epo[i] do
			     if not contains(L,j) then
				     e := [i,j];
				     pp := price[e[1]] - (Ew[e] + price[e[2]]);
				     if pp = 0 and flow[e] < Ecap[e] then
					     Lh := Lh union {j};
					     label[j] := e;
				     end_if;
			     end_if;
		     end_for;
		     for j in Epr[i] do
			     if not contains(L,j) then
				     e := [j,i];
				     pp := price[e[1]] - (Ew[e] + price[e[2]]);
				     if pp = 0 and 0 < flow[e] then #- low_capacity[e] < flow[e] -#
					     Lh := Lh union {j};
					     label[j] := e;
				     end_if;
			     end_if;
		     end_for;
		     L := L union Lh;
		     for j in Lh do
			     if deficit[j] < 0 then
				     flow_augmentation(v,j,deficit,flow,Ecap);
				     flow := %[1];
				     deficit := %2[2];
				     return(flow,deficit,price,DD);
			     end_if;
		     end_for;
	     end_if;
     end_while;
end_proc:

   #-
     Initialisation of 
     	flow - network flow
        price - local prices
        deficit - supply/demand of nodes
        DD directional derivative
   -#
   price := table(V[i] = 0 $ i=1..nops(V));
   deficit := table(V[i] = Vw[V[i]] $ i=1..nops(V));
   for e in Ed do 
      i := price[e[1]] - (Ew[e] + price[e[2]]);
      if i <= 0 then
         flow[e] := 0;  #- lower_capacity[e] -#
         deficit[e[1]] := deficit[e[1]] - flow[e];
         deficit[e[2]] := deficit[e[2]] + flow[e];
      else
         flow[e] := Ecap[e];
         deficit[e[1]] := deficit[e[1]] - flow[e];
         deficit[e[2]] := deficit[e[2]] + flow[e];
      end_if;
   end_for;
   DD := 0;
   f := fun(bool(deficit[args(1)] > 0));
   
   repeat
      a := select(V, f);
      if nops(a) = 0 then
	      break; #- Termination: there are no more deficit nodes -#
      end_if;
      a := relax_step(a[1],Ed,Ecap,Ew,Epo,Epr,flow,deficit,price,DD);
      flow := a[1];
      deficit := a[2];
      price := a[3];
      userinfo(1,"price=",price);
      DD := a[4];
   until FALSE end_repeat;
   flow,price;
end_proc:
