#-
  ShowGraph - graphical plot of the network
  ShowGraph(N)
  Parameters:
     N - Network
-#
Network::ShowGraph := proc(N)
local alpha, i, Points, Edges, V, ED, e, ne, v, w;
begin
   if testargs() then
      if args(0) <> 1 then
	 error("Wrong number of arguments!");
      end_if;
      Network::graph_check(N);
   end_if;
   V := Network::Vertex(N);
   ED := Network::Edge(N);


   nv := nops(V);
   ne := nops(ED);
   alpha := float(2*PI / (nv));
   Points := [point(1.0, 0.0)];
   Edges := [];
   for i from 1 to nv do
       Points := append(Points, point(cos(i*alpha), sin(i*alpha)));
   end_for;
   
   for i from 1 to ne do
      e := ED[i];
      v := e[1]; w := e[2];
      v := contains(V,v); w := contains(V,w);
      Edges := append(Edges, plotlib::vector(Points[v],Points[w], PI/6.0, 0.05));
   end_for;
   plot2d( Axes = None, PointWidth = 5, LineWidth = 1, PointStyle = FilledCircles, [Mode=List, Points], [Mode=List, Edges]);
end_proc:

