#-
 spath - generates pathes for ShortPath, ShortPathTo and LongPath
 Parameters:
   V - list of nodes
   d - sequence with table of distances and a table with successors or
       predecessors
   a - number, specifying the result: Length (0,1), Path (10), 
       Length & Path (11)
   ww - 1 if one distance (v,..,w) is desired, 0 if all distances are desired
   www - the target node (if ww = 1)
   app - 0 if the pathes are to one single node are desired, 1 if the pathes
         from one single node are desired
-#
Network::spath_eval := proc(V,d,a,ww,www,app)
local dist,sp,path,i,w,u,f;
begin
   res := [];
   dist := op(d,1);
   d := op(d,2);

   if ww = 1 then  #- final node specified -#
      case a
          of 0 do
            res := [dist[www]];
            break;
         of 1 do
            res := [dist[www]];
            break
         of 11 do
            res := [dist[www]];
         of 10 do
            if dist[www] = infinity then
   		res := append(res, []);
	    else
               w := www;
               path := [w];
               repeat
                  u := d[w];
                  if app =0 then
                     path := linsert(path,u,1);
                  else
                     path := append(path,u);
                  end_if;
                  w := u;
               until (w = v) end_repeat;
               res := append(res,path);
            end_if;
      end_case;
   else #- no final node specified -#
      case a
          of 0 do
            res := [dist];
            break;
         of 1 do
            res := [dist];
            break
         of 11 do
            res := [dist];
         of 10 do
     	    sp := table();
	        f := fun(bool((args(1) <> v) and (dist[args(1)] <> infinity)));
            for i in select(V, f) do
               path := [i];
               w := i;
               repeat 
	          u := d[w];
	          if app =0 then
                 path := linsert(path,u,1);
              else
                 path := append(path,u);
              end_if;
	          w := u;
               until (w = v) or (contains(sp,w)) end_repeat;
               if contains(sp,w) then
	          path[1] := NIL;
	          sp[i] := sp[w].path;
               else
	          sp[i] := path;
               end_if;
            end_for;
            res := append(res,sp);
      end_case;
   end_if;
   op(res);
end_proc:
