 #-
 TopSort - topological sorting of a network
 TopSort(G)
 Parameters:
   G - network
-#
Network::TopSort := proc(G)
local indg,i,j,V,Epr,Epo,C,Q,d;
begin
   if testargs() then
      Network::graph_check(G);
   end_if;
   V := Network::Vertex(G);
   Epr := Network::Epre(G);
   Epo := Network::Epost(G);

   indeg := Network::InDegree(G);
   C := 0; Q := [];
   for i in V do 
	if indeg[i] = 0 then
		Q := append(Q,i);
	end_if;
   end_for;
   #-
    G contains cycle if there isn't any node with indeg[i] = 0
   -#
   if nops(Q) = 0 then
	error("Network contains cycle");
   end_if;
   repeat
     i := Q[1];
     Q[1] := NIL;
     C := C+1;
     d[i] := C;
     for j in Epo[i] do
	indeg[j] := indeg[j] - 1;
	if indeg[j] = 0 then
		Q := append(Q, j);
	end_if;
     end_for;
   until Q = [] end_repeat;
   if C < nops(V) then
	error("Network contains cycle");
   end_if;
   d;
end_proc:
