if type(Ecpp)<>DOM_DOMAIN then Ecpp:=domain() end_if:

if Ecpp::B=FAIL then Ecpp::B:=1000 end_if: # for factors<=Ecpp::B, try direct method #
if Ecpp::maxh=FAIL then Ecpp::maxh:=17 end_if:
if Ecpp::maxit=FAIL then Ecpp::maxit:=10000 end_if: # for Pollard's rho method #

numlib::proveprime:=proc(n) # returns a prime certificate, or FAIL #
local D,l,v,r,m,ll,cert,A;
begin
   if isprime(n)=FALSE then 
      userinfo(1,"composite by isprime"); return(FALSE) end_if;
   if n<=max(11,Ecpp::B) then TRUE 
   # the method does not work for n=2,3,5,7,11 because the bound (n^(1/4)+1)^2 is too
     high, thus there is no possible next candidate (n^(1/4)+1)^2 <= n1 < n #
   else # n>Ecpp::B #
      for D in Ecpp::get_good_D(Ecpp::maxh) do
            if (A:=Ecpp::is_a_norm(n,D))<>FALSE then 
	       userinfo(2,"next good D is",D);
	       for r in [-1,1] do
		  m:=n+1+r*A;
		  l:=Ecpp::prob_factored(m);
		  if l<>FALSE then 
                     userinfo(2,"A=",A,"m=",m,"pseudo factorization of m=",l);
		     if l[nops(l)]<n then
			   cert:=Ecpp::get_cert(n,D,m,l);
                           if cert<>FAIL then
                              userinfo(2,"found working D:",D);
			      userinfo(1,"found next candidate=",l[nops(l)]);
			      ll:=numlib::proveprime(l[nops(l)]);
			      if ll<>FAIL then 
				return([n,D,l,cert],(if ll=TRUE then null() else ll end_if))
                              end_if
                           end_if
		     end_if
		  end_if;
	       end_for;
            end_if
      end_for;
      userinfo(1,"try to increase Ecpp::maxh or Ecpp::maxit");
      FAIL
   end_if
end_proc:

# tries to find a,b,P,s that satisfies the conditions of the theorem #
Ecpp::get_cert := proc(N,D,m,l)
local h,j,ab,P,mP,zer,s,Q,bnd,q,ls,c;
begin
   h:=subsop(Ecpp::Hilbert(D),3=IntMod(N));
   j:=[faclib::roots(h)];
   if j=[] then userinfo(1,"found no root of",expr(h),"modulo",N); return(FAIL) end_if;
   j:=j[1];
   ab:=Ecpp::find_eq(j,N);
   P:=Ecpp::findP(ab,N);
   P:=EC::new(P,1,ab,N);
   mP:=EC::scalmult(P,m);
   zer:=EC::zero(ab,N);
   if mP<>zer then # try the other curve, cf page 67 #
      # first find a quadratic non-residue c mod N #
      for c from 2 to N-1 do if numlib::jacobi(c,N)=-1 then break end_if end_for;
      ab:=(ab[1]*c^2 mod N), (ab[2]*c^3 mod N);
      P:=Ecpp::findP(ab,N);
      P:=EC::new(P,1,ab,N);
      mP:=EC::scalmult(P,m);
      zer:=EC::zero(ab,N);
   end_if;
   if mP<>zer then userinfo(1,"m*P<>0 for N=",N,"m=",m,"P=",P,ab); return(FAIL) end_if;
   s:=l[nops(l)]; ls:=s;
   Q:=EC::scalmult(P,m/s);
   if Q=zer then userinfo(2,"(m/s)*P=0"); return(FAIL) end_if;
   bnd:=float((N^(1/4)+1)^2);
   j:=nops(l)-1; while s<=bnd do
      if j=0 then break end_if;
      q:=l[j];
      Q:=EC::scalmult(P,m/q);
      if Q<>zer then s:=s*q; ls:=q,ls end_if;
      j:=j-1;
   end_while;
   if s<=bnd then userinfo(1,"s not large enough",s<=bnd); FAIL
   else ab,extop(P,1,2),[ls]
   end_if
end_proc:

numlib::check := proc()
local li,l,i,N,D,ab,P,m,mP,s,Q,bnd,zer,q;
begin
   userinfo(2,
"The proof is based on the following theorem due to Gold-
wasser and Kilian, see article \"Almost all primes can be quickly 
certified\", Proc. 18th STOC, ACM, 1986:

  Theorem GK: Let N be an integer prime to 6, E an elliptic curve over 
  Z/NZ, together with a point P on E and m and s two integers with s 
  dividing m. For each prime divisor q of s, we put (m/q)P = (xq:yq:zq).
  We assume that mP is the zero of E and gcd(zq,N)=1 for all q. Then, 
  if s>(N^(1/4)+1)^2, N is prime.");
   for i from 1 to args(0) do
      li:=args(i);
      N:=li[1]; D:=li[2]; m:=_mult(op(li[3]));
      userinfo(2,"N=",N,"D=",D,"m=",m);
      ab:=li[4],li[5];
      P:=EC::new(li[6],li[7],1,ab,N);
      userinfo(2,"a=",ab[1]," b=",ab[2],"P=",P);
      if not Ecpp::is_P_on_E(li[6],li[7],ab,N) then error("P is not on E") end_if;
      mP:=EC::scalmult(P,m);
      userinfo(2,"m*P=",mP);
      zer:=EC::zero(ab,N);
      if mP<>zer then error("m*P is not zero") end_if;
      l:=li[8];
      s:=_mult(op(l));
      for q in l do
         Q:=EC::scalmult(P,m/q);
         if Q=zer then error("Q should not be zero for q=".q) end_if;
      end_for;
      bnd:=float((N^(1/4)+1)^2);
      if s>bnd then userinfo(2,s,">",(N^(1/4)+1)^2,"=",bnd)
      else error("s <= (N^(1/4)+1)^2=".expr2text(bnd))
      end_if;
      userinfo(2,"Theorem GK applies for N=".N." E(".ab[1].",".ab[2].") P=(".extop(P,1).":".extop(P,2).":1) m=".m." s=".s);
      userinfo(1,"therefore",N," is prime if ",l[nops(l)]," is prime");
   end_for;
   TRUE
end_proc:

Ecpp::is_P_on_E := proc(x,y,a,b,n)
begin
   bool(y^2-(x^3+a*x+b) mod n = 0)
end_proc:

# find an equation of the curve E of invariant j and whose cardinality
   modulo p is m (step 2.5) with p= \pi \pi' (page 57),
   returns a,b #
Ecpp::find_eq := proc(j,p)
local k;
begin
   k:=j/(1728-j) mod p;
   3*k mod p,2*k mod p # equation (39) page 57 with c=1 #
end_proc:

Ecpp::findP := proc(a,b,n) # cf [Morain 88], page 69 #
local x,y,l,c;
option remember; 
begin
   for x from 0 to n-1 do
      if numlib::jacobi((c:=x^3+a*x+b),n)=1 then
         userinfo(2,"computing a square root of",c,"modulo",n);
         # faclib::roots is faster than numlib::msqrts, but numlib::ressol2 is even faster #
         l:=numlib::ressol2(c,n); return(x,l)
      end_if
   end_for
end_proc:

# gives all primes less than B #
Ecpp::primes_less_than := proc(B) local l,p;
option remember;
begin
   l:=2; p:=3;
   repeat
      l:=l,p;
      p:=nextprime(p+2)
   until p>B end_repeat;
   _mult(l)
end_proc:
# 0.7s for B=1000 : 168 primes #
# 6.8s for B=10000 : 1229 primes #
# 207s for B=100000 : 9592 primes #
# B=1000000 : 78498 primes #

Ecpp::ifactor:=proc(F) local l,i;
begin
   l:=ifactor(F);
   (l[2*i]$l[2*i+1])$i=1..(nops(l) div 2)
end_proc:

Ecpp::prob_factored:=proc(N) local F,p,i,l,g;
begin
   F:=null();
   p:=Ecpp::primes_less_than(1000);
   while (g:=igcd(N,p))<>1 do
      F:=F,Ecpp::ifactor(g);
      N:=N div g;
      if N=1 then return((Ecpp::prob_factored(args()):=[F]))
      elif isprime(N) then return((Ecpp::prob_factored(args()):=[F,N]))
      end_if
   end_while;
   if isprime(N) then Ecpp::prob_factored(args()):=[F,N] 
   else 
      repeat
         userinfo(2,"trying Pollard's rho method on",N);
         N:=numlib::pollard(N,Ecpp::maxit);
         if N=FAIL then
            userinfo(2,"failed to factor");
            return(FALSE)
         else
            userinfo(2,"found factor",N[1]);
            l:=ifactor(N[1]);
            F:=F,(l[2*i]$l[2*i+1])$i=1..(nops(l) div 2);
            N:=N[2];
            if isprime(N) then return((Ecpp::prob_factored(args()):=[F,N])) end_if
         end_if
      until FALSE end_repeat;
   end_if
end_proc:

Ecpp::Hilbert := proc(D) # Hilbert's polynomial associated to D #
local p,prqf,x,l,maxerr,q,err,c;
option remember;
begin
   p:=1; l:=Ecpp::H(D);
   for prqf in l do
      # page 34 : omega_r = (-b_r+I*sqrt(D))/(2a_r) #
      p:=expand(p*(x-Ecpp::j(op(prqf,1),op(prqf,2),D)));
   end_for;
   # round coefficients #
   maxerr:=0;
   for i from 0 to nops(l) do
      c:=coeff(p,x,i);
      err:=abs(Im(c));
      if err>maxerr then maxerr:=err end_if;
      c:=Re(c);
      q[i]:=round(c);
      err:=abs(c-q[i]);
      if err>maxerr then maxerr:=err end_if;
   end_for;
   userinfo(2,"max rounding error=",maxerr);
   poly(_plus(q[i]*x^i$hold(i)=0..nops(l)),[x])
end_proc:

# checks D>=1 and (D = 3 mod 4 or D = {4,8} mod 16) and p^2 does not divide D #
Ecpp::is_fund_discr := proc(D)
local l,i;
option remember;
begin
   if (D mod 4 <> 3) and not contains({4,8},D mod 16) then FALSE
   else
      l:=ifactor(D);
      for i from 1 to nops(l) div 2 do
         if op(l,2*i) mod 2 = 1 and op(l,2*i+1)>1 then return(FALSE) end_if
      end_for;
      TRUE
   end_if
end_proc:

# gives a list of all fundamental discriminants of h(D)<=maxh #
Ecpp::get_good_D := proc(maxh)
local i;
begin
   _concat(Ecpp::D_of_h(i)$i=1..maxh)
end_proc:

Ecpp::D_of_h := proc(h)
local D,l;
option remember;
begin
   userinfo(1,"computing the discriminants of order",h);
   l:=null();
   for D from 7 to 163*h^2 do
      if Ecpp::is_fund_discr(D) then
         if Ecpp::h(D)=h then l:=l,D end_if
      end_if
   end_for;
   [l]
end_proc:

Ecpp::D_of_h(1):=[7, 8, 11, 19, 43, 67, 163]:
Ecpp::D_of_h(2):=[15, 20, 24, 35, 40, 51, 52, 88, 91, 115, 123, 148, 187, 232, 235, 267, 403, 427]:
Ecpp::D_of_h(3):=[23, 31, 59, 83, 107, 139, 211, 283, 307, 331, 379, 499, 547, 643, 883, 907]:
Ecpp::D_of_h(4):=
[39, 55, 56, 68, 84, 120, 132, 136, 155, 168, 184, 195, 203, 219, 228, 259,
 280, 291, 292, 312, 323, 328, 340, 355, 372, 388, 408, 435, 483, 520, 532, 
555, 568, 595, 627, 667, 708, 715, 723, 760, 763, 772, 795, 955, 1003, 1012, 
1027, 1227, 1243, 1387, 1411, 1435, 1507, 1555]:
Ecpp::D_of_h(5):=
[47, 79, 103, 127, 131, 179, 227, 347, 443, 523, 571, 619, 683, 691, 739,
787, 947, 1051, 1123, 1723, 1747, 1867, 2203, 2347, 2683]:
Ecpp::D_of_h(6):=
[87, 104, 116, 152, 212, 244, 247, 339, 411, 424, 436, 451, 472, 515, 628,
 707, 771, 808, 835, 843, 856, 1048, 1059, 1099, 1108, 1147, 1192, 1203, 
1219, 1267, 1315, 1347, 1363, 1432, 1563, 1588, 1603, 1843, 1915, 1963, 2227, 
2283, 2443, 2515, 2563, 2787, 2923, 3235, 3427, 3523, 3763]:
Ecpp::D_of_h(7):=
[71, 151, 223, 251, 463, 467, 487, 587, 811, 827, 859, 1163, 1171, 1483, 1523, 
1627, 1787, 1987, 2011, 2083, 2179, 2251, 2467, 2707, 3019, 3067, 3187, 
3907, 4603, 5107, 5923]:
Ecpp::D_of_h(8):=
[95, 111, 164, 183, 248, 260, 264, 276, 295, 299, 308, 371, 376, 395, 420,
 452, 456, 548, 552, 564, 579, 580, 583, 616, 632, 651, 660, 712, 820, 840, 
852, 868, 904, 915, 939, 952, 979, 987, 995, 1032, 1043, 1060, 1092, 1128, 
1131, 1155, 1195, 1204, 1240, 1252, 1288, 1299, 1320, 1339, 1348, 1380, 1428, 
1443, 1528, 1540, 1635, 1651, 1659, 1672, 1731, 1752, 1768, 1771, 1780, 1795, 
1803, 1828, 1848, 1864, 1912, 1939, 1947, 1992, 1995, 2020, 2035, 2059, 2067, 
2139, 2163, 2212, 2248, 2307, 2308, 2323, 2392, 2395, 2419, 2451, 2587, 2611, 
2632, 2667, 2715, 2755, 2788, 2827, 2947, 2968, 2995, 3003, 3172, 3243, 3315, 
3355, 3403, 3448, 3507, 3595, 3787, 3883, 3963, 4123, 4195, 4267, 4323, 4387, 
4747, 4843, 4867, 5083, 5467, 5587, 5707, 5947, 6307]:
Ecpp::D_of_h(9):=
[199, 367, 419, 491, 563, 823, 1087, 1187, 1291, 1423, 1579, 2003, 2803, 3163, 
3259, 3307, 3547, 3643, 4027, 4243, 4363, 4483, 4723, 4987, 5443, 6043, 6427, 
6763, 6883, 7723, 8563, 8803, 9067, 10627]:
Ecpp::D_of_h(10):=
[119, 143, 159, 296, 303, 319, 344, 415, 488, 611, 635, 664, 699, 724, 779, 
788, 803, 851, 872, 916, 923, 1115, 1268, 1384, 1492, 1576, 1643, 1684, 
1688, 1707, 1779, 1819, 1835, 1891, 1923, 2152, 2164, 2363, 2452, 2643, 
2776, 2836, 2899, 3028, 3091, 3139, 3147, 3291, 3412, 3508, 3635, 3667, 
3683, 3811, 3859, 3928, 4083, 4227, 4372, 4435, 4579, 4627, 4852, 4915, 
5131, 5163, 5272, 5515, 5611, 5667, 5803, 6115, 6259, 6403, 6667, 7123, 
7363, 7387, 7435, 7483, 7627, 8227, 8947, 9307, 10147, 10483, 13843]:
Ecpp::D_of_h(11):=
[167, 271, 659, 967, 1283, 1303, 1307, 1459, 1531, 1699, 2027, 2267, 2539,
 2731, 2851, 2971, 3203, 3347, 3499, 3739, 3931, 4051, 5179, 5683, 6163, 
6547, 7027, 7507, 7603, 7867, 8443, 9283, 9403, 9643, 9787, 10987, 13003, 
13267, 14107, 14683, 15667]:
Ecpp::D_of_h(12):=
[231, 255, 327, 356, 440, 516, 543, 655, 680, 687, 696, 728, 731, 744, 755, 
804, 888, 932, 948, 964, 984, 996, 1011, 1067, 1096, 1144, 1208, 1235, 1236, 
1255, 1272, 1336, 1355, 1371, 1419, 1464, 1480, 1491, 1515, 1547, 1572, 1668, 
1720, 1732, 1763, 1807, 1812, 1892, 1955, 1972, 2068, 2091, 2104, 2132, 2148, 
2155, 2235, 2260, 2355, 2387, 2388, 2424, 2440, 2468, 2472, 2488, 2491, 2555, 
2595, 2627, 2635, 2676, 2680, 2692, 2723, 2728, 2740, 2795, 2867, 2872, 2920, 
2955, 3012, 3027, 3043, 3048, 3115, 3208, 3252, 3256, 3268, 3304, 3387, 3451, 
3459, 3592, 3619, 3652, 3723, 3747, 3768, 3796, 3835, 3880, 3892, 3955, 3972, 
4035, 4120, 4132, 4147, 4152, 4155, 4168, 4291, 4360, 4411, 4467, 4531, 4552, 
4555, 4587, 4648, 4699, 4708, 4755, 4771, 4792, 4795, 4827, 4888, 4907, 4947, 
4963, 5032, 5035, 5128, 5140, 5155, 5188, 5259, 5299, 5307, 5371, 5395, 5523, 
5595, 5755, 5763, 5811, 5835, 6187, 6232, 6235, 6267, 6283, 6472, 6483, 6603, 
6643, 6715, 6787, 6843, 6931, 6955, 6963, 6987, 7107, 7291, 7492, 7555, 7683, 
7891, 7912, 8068, 8131, 8155, 8248, 8323, 8347, 8395, 8787, 8827, 9003, 9139, 
9355, 9523, 9667, 9843, 10003, 10603, 10707, 10747, 10795, 10915, 11155, 11347, 
11707, 11803, 12307, 12643, 14443, 15163, 15283, 16003, 17803]:
Ecpp::D_of_h(13):=
[191, 263, 607, 631, 727, 1019, 1451, 1499, 1667, 1907, 2131, 2143, 2371, 2659, 
2963, 3083, 3691, 4003, 4507, 4643, 5347, 5419, 5779, 6619, 7243, 7963, 9547, 
9739, 11467, 11587, 11827, 11923, 12043, 14347, 15787, 16963, 20563]:
Ecpp::D_of_h(14):=
[215, 287, 391, 404, 447, 511, 535, 536, 596, 692, 703, 807, 899, 1112, 1211, 
1396, 1403, 1527, 1816, 1851, 1883, 2008, 2123, 2147, 2171, 2335, 2427, 2507, 
2536, 2571, 2612, 2779, 2931, 2932, 3112, 3227, 3352, 3579, 3707, 3715, 3867, 
3988, 4187, 4315, 4443, 4468, 4659, 4803, 4948, 5027, 5091, 5251, 5267, 5608, 
5723, 5812, 5971, 6388, 6499, 6523, 6568, 6979, 7067, 7099, 7147, 7915, 8035, 
8187, 8611, 8899, 9115, 9172, 9235, 9427, 10123, 10315, 10363, 10411, 11227, 
12147, 12667, 12787, 13027, 13435, 13483, 13603, 14203, 16867, 18187, 18547, 
18643, 20227, 21547, 23083, 30067]:
Ecpp::D_of_h(15):=
[239, 439, 751, 971, 1259, 1327, 1427, 1567, 1619, 2243, 2647, 2699, 2843,
3331, 3571, 3803, 4099, 4219, 5003, 5227, 5323, 5563, 5827, 5987, 6067, 6091, 
6211, 6571, 7219, 7459, 7547, 8467, 8707, 8779, 9043, 9907, 10243, 10267, 
10459, 10651, 10723, 11083, 11971, 12163, 12763, 13147, 13963, 14323, 14827, 
14851, 15187, 15643, 15907, 16603, 16843, 17467, 17923, 18043, 18523, 19387, 
19867, 20707, 22003, 26203, 27883, 29947, 32323, 34483]:
Ecpp::D_of_h(16):=
[399, 407, 471, 559, 584, 644, 663, 740, 799, 884, 895, 903, 943, 1015, 1016, 
1023, 1028, 1047, 1139, 1140, 1159, 1220, 1379, 1412, 1416, 1508, 1560, 1595, 
1608, 1624, 1636, 1640, 1716, 1860, 1876, 1924, 1983, 2004, 2019, 2040, 2056, 
2072, 2095, 2195, 2211, 2244, 2280, 2292, 2296, 2328, 2356, 2379, 2436, 2568, 
2580, 2584, 2739, 2760, 2811, 2868, 2884, 2980, 3063, 3108, 3140, 3144, 3160, 
3171, 3192, 3220, 3336, 3363, 3379, 3432, 3435, 3443, 3460, 3480, 3531, 3556, 
3588, 3603, 3640, 3732, 3752, 3784, 3795, 3819, 3828, 3832, 3939, 3976, 4008, 
4020, 4043, 4171, 4179, 4180, 4216, 4228, 4251, 4260, 4324, 4379, 4420, 4427, 
4440, 4452, 4488, 4515, 4516, 4596, 4612, 4683, 4687, 4712, 4740, 4804, 4899, 
4939, 4971, 4984, 5115, 5160, 5187, 5195, 5208, 5363, 5380, 5403, 5412, 5428, 
5460, 5572, 5668, 5752, 5848, 5860, 5883, 5896, 5907, 5908, 5992, 5995, 6040, 
6052, 6099, 6123, 6148, 6195, 6312, 6315, 6328, 6355, 6395, 6420, 6532, 6580, 
6595, 6612, 6628, 6708, 6747, 6771, 6792, 6820, 6868, 6923, 6952, 7003, 7035, 
7051, 7195, 7288, 7315, 7347, 7368, 7395, 7480, 7491, 7540, 7579, 7588, 7672, 
7707, 7747, 7755, 7780, 7795, 7819, 7828, 7843, 7923, 7995, 8008, 8043, 8052,
8083, 8283, 8299, 8308, 8452, 8515, 8547, 8548, 8635, 8643, 8680, 8683, 8715, 
8835, 8859, 8932, 8968, 9208, 9219, 9412, 9483, 9507, 9508, 9595, 9640, 9763, 
9835, 9867, 9955, 10132, 10168, 10195, 10203, 10227, 10312, 10387, 10420, 10563,
10587, 10635, 10803, 10843, 10948, 10963, 11067, 11092, 11107, 11179, 11203, 
11512, 11523, 11563, 11572, 11635, 11715, 11848, 11995, 12027, 12259, 12387, 
12523, 12595, 12747, 12772, 12835, 12859, 12868, 13123, 13192, 13195, 13288, 
13323, 13363, 13507, 13795, 13819, 13827, 14008, 14155, 14371, 14403, 14547, 
14707, 14763, 14995, 15067, 15387, 15403, 15547, 15715, 16027, 16195, 16347, 
16531, 16555, 16723, 17227, 17323, 17347, 17427, 17515, 18403, 18715, 18883, 
18907, 19147, 19195, 19947, 19987, 20155, 20395, 21403, 21715, 21835, 22243, 
22843, 23395, 23587, 24403, 25027, 25267, 27307, 27787, 28963, 31243]:
Ecpp::D_of_h(17):=
[383, 991, 1091, 1571, 1663, 1783, 2531, 3323, 3947, 4339, 4447, 4547, 4651, 
5483, 6203, 6379, 6451, 6827, 6907, 7883, 8539, 8731, 9883, 11251, 11443, 
12907, 13627, 14083, 14779, 14947, 16699, 17827, 18307, 19963, 21067, 23563, 
24907, 25243, 26083, 26107, 27763, 31627, 33427, 36523, 37123]:

# gives the factorization -D = qstar[1] ... qstar[t] (page 31) #
Ecpp::factorD := proc(d) 
local l,q48,qplus,qminus,i,q;
option remember;
begin
      if d mod 4 = 0 then
         if d mod 8 = 0 then q48:=8 else q48:=4 end_if;
         d:=d/q48
      else q48:=1
      end_if;
      l:=ifactor(d);
      q48:=-q48*op(l,1); # for -D #
      qplus:=[]; qminus:=[];
      for i from 1 to nops(l) div 2 do
         if op(l,2*i+1)>1 then error("D divisible by the square of an odd prime") end_if;
         q:=op(l,2*i);
         if (q-1) mod 4 = 0 then qplus:=append(qplus,q) 
         else qminus:=append(qminus,-q); q48:=-q48
         end_if;
      end_for;
      if q48=1 then op(qplus),op(qminus)
      elif (q48=-4) or (abs(q48)=8) then  q48,op(qplus),op(qminus)
      else print(q48);error("wrong q48")
      end_if
end_proc:

# check if p is a norm in Q(sqrt(-D)), that is -D is good for p,
   which means 4*p = A^2 + D*B^2 with A,B in Z,
   returns A if there is a solution, FALSE otherwise #
Ecpp::is_a_norm := proc(p,D)
local l,qstar;
begin
   userinfo(2,"Checking if p=",p,"is a norm for D=",D);
   # first check that p \in G_0(-D) (cf pages 52, 53) #
   l:=Ecpp::factorD(D);
   for qstar in [l] do
      if numlib::jacobi(qstar,p)<>1 then
         userinfo(3,"  impossible by Jacobi");
         return(FALSE) 
      end_if
   end_for; 
   # then find a square root of -D mod p #
   # if D=0 mod 4 ==> Cornacchia with d=D/4
        D=7 mod 8 ==> Cornacchia with D
        D=3 mod 8 ==> Cornacchia on x^2+x+(D+1)/4 #
   if D mod 4 = 0 then # D = 4*d ==> we have to solve p = (A/2)^2 + d*B^2 #
      l:=Ecpp::cornacchia(D/4,p,p);
      if l=null() then return(FALSE)
      elif nops([l])=2 then return(2*l[1]) # p=a^2+(D/4)*b^2 ==> 4p=(2a)^2+D*b^2 #
      else error("bad output from cornacchia")
      end_if
   else # D mod 4 = 3 #
      # first try with A and B even ==> p = (A/2)^2 +D*(B/2)^2 #
      l:=Ecpp::cornacchia(D,p,p);
      if l=null() then
         l:=Ecpp::cornacchia(D,p,4*p);
         if nops([l])=2 then return(l[1]) else return(FALSE) end_if
      elif nops([l])=2 then return(2*l[1])
      else error("bad output from cornacchia")
      end_if
   end_if;
end_proc:

Ecpp::h:=proc(D)
option remember;
begin
  nops(Ecpp::H(D))
end_proc:

# page 31 : H(D) = set of primitive reduced quadratics forms of discriminant -D #
# solutions of b^2-4*a*c = -D #
Ecpp::H:=proc(D)
local a,b,c,bmax,p,red;
begin
   bmax:=trunc(float((D/3)^(1/2)));
   red:=[];
   for b from -bmax to bmax do
      p:=b^2+D; # should equal 4*a*c #
      if p mod 4 <> 0 then next end_if;
      p:=p div 4; # should equal a*c with a <= c #
      a:=abs(b); # because we must have |b| <= a #
      if a=0 then a:=1 end_if; # because a=0 cannot be a solution #
      while a*a<=p do
         if p mod a = 0 then 
            if (a=abs(b) or a*a=p) and b<=0 then 
            else red:=append(red,[a,b,p/a]) 
            end_if
         end_if;
         a:=a+1;
      end_while;
   end_for;
   red
end_proc:
Ecpp::H(4):=[[1,0,1]]: # otherwise we find [] #

# finds a solution of u^2+d*v^2=P, cf page 54 of [AtMo93] #
Ecpp::cornacchia := proc(d,p,P) # P = p or 4*p and p is prime #
local x,r,v,x0;
begin
   if p=P then 
      l:=numlib::ressol2(-d,p);
      l:=[l,(-l mod p)];
   else 
      l:=numlib::msqrts(-d,P);
   end_if;
   if nops(l)=0 then null() # no solution, otherwise u/v would be a root #
   else
      x0:=max(op(l));
      r:=0; x[-1]:=P; x[0]:=x0;
      while x[r]^2>=P do
         r:=r+1;
         x[r]:=x[r-2] mod x[r-1];
      end_while;
      v:=(P-x[r]^2)/d;
      if type(v)<>DOM_INT then null()
      elif numlib::issqr(v) then x[r],v^(1/2)
      else null() 
      end_if
   end_if;
end_proc:

Ecpp::eta:=proc(z,N) # truncate to the first N terms #
local s,n,q;
begin
   q:=float(exp(2*I*PI*z));
   s:=0;
   for n from 1 to N do s:=s+(-1)^n*(q^(n*(3*n-1)/2)+q^(n*(3*n+1)/2)) end_for;
   q^(1/24)*(1+s)
end_proc:

# equation (22) page 42: computes the precision required #
Ecpp::Prec:=proc(D)
local l,h,i;
begin
   l:=Ecpp::H(D);
   h:=nops(l);
   ceil(float(10+PI*D^(1/2)/ln(10)*_plus(1/l[i][1]$i=1..h)))
end_proc:
# Prec3):=1: Prec(4):=1: Prec(7):=1: Prec(8):=1: Prec(11):=1: #
# Prec(15):=10: #
# Prec(719):=222: #

# page 42 : to compute j(z), first compute eta(z), eta(2*z) and f2(z) #
Ecpp::j := proc(a,b,D)
local prec,S,N,e,z,DIGITS,e2,f2,Rez,Imz;
begin
   prec:=Ecpp::Prec(D);
   DIGITS:=prec;
   S:=ceil(float(2/3*(ln(6)+prec*ln(10))/PI/D^(1/2)));
   N:=ceil(float((S*a)^(1/2)));
   z:=float((-b+I*D^(1/2))/2/a);
   e:=Ecpp::eta(z,N);
   e2:=Ecpp::eta(2*z,ceil(float((S*a/2)^(1/2))));
   f2:=(2.0)^(1/2)*e2/e;
   f2:=f2^24;
   (f2+16)^3/f2
end_proc:

EC:=domain():
EC::name:="EC":

EC::new:=proc(x,y,z,a,b,n) begin new(EC,x,y,z,a,b,n) end_proc:

EC::_plus := proc(M1,M2)
local x1,x2,y1,y2,a,n,lambda,x3,y3;
begin
   x1:=extop(M1,1); y1:=extop(M1,2);
   x2:=extop(M2,1); y2:=extop(M2,2);
   a:=extop(M1,4); n:=extop(M1,6);
   if x1=x2 then 
      if extop(M1,3)=0 then return(M2)
      elif y1+y2 mod n=0 then return(extsubsop(M1,1=0,2=1,3=0)) end_if;
      lambda:=(3*x1^2+a)/(2*y1)
   else lambda:=(y2-y1)/(x2-x1)
   end_if;
   x3:=(lambda^2-x1-x2) mod n;
   y3:=(lambda*(x1-x3)-y1) mod n;
   extsubsop(M1,1=x3,2=y3)
end_proc:

EC::zero:=proc(a,b,n) begin new(EC,0,1,0,a,b,n) end_proc:

EC::scalmult := proc(M,n)
local MM;
begin
   if n=1 then M
   else
      MM:=EC::scalmult(EC::_plus(M,M),n div 2);
      if n mod 2=0 then MM
      else EC::_plus(MM,M)
      end_if
   end_if
end_proc:

EC::print:=proc(M) begin "( ".extop(M,1)." : ".extop(M,2)." : ".extop(M,3)." )" end_proc:
