# solves a set of linear ode in z
  l is a set {u,v,...} of indeterminates for the functions u(z), v(z)
  A is a table of (ord+1) lists of n lists of n coefficients
  b is a list
  n=nops(l) is the number of unknown functions
  ord=nops(A)-1 is the maximal order of the equations
  the coefficient of diff(op(l,j)(z),z$k) in equation i is stored in A[k][i][j]
  and the inhomogeneous coefficient of equation i is stored in b[i]

  Example: ode::linsys(table(0 = [[-1, -8], [-9, -2]], 1 = [[0, 1], [1, 0]]),
                       [-1, 0], {y1, y2}, t, 2, 1); solves the first-order system
           y2'(t)-y1(t)-8*y2(t)=1, y1'(t)-9*y1(t)-2*y2(t)=0 with 
#
ode::linsys := proc(AA,b,l,z,n,ord)
local k,lc,M,Id,d,invlc,C,x,eigenvals,lambda,eigenvects,sol,v,i,m,A,y,j,hsol;
begin
   userinfo(1,"linear system");
   # first transform to matrices #
   loadlib("linalg");
   M := Matrix();
   for k from 0 to ord do A[k]:=M(AA[k]) end_for;
   # normalize the leading coefficient #
   lc:=A[ord];
   Id:=M(n,n,1,Diagonal);
   if lc<>Id then
      if traperror((invlc:=lc^(-1)))<>0 then
         error("singular leading coefficient")
      end_if;
      for k from 0 to ord-1 do A[k]:=invlc * A[k] end_for
   end_if;
   if ord=1 and not has(AA[0],z) then # solve Y' + A[0] * Y = -b #
      lc:=[]; # will contain the integration constants #
      # find the eigenvalues #
      C:=A[0] + x*Id;
      d:=linalg::det(C);
      eigenvals:=solve(d,x);
      userinfo(2,"eigenvalues are",eigenvals);
      if type(eigenvals)<>DOM_LIST then return(FAIL) end_if;
      if nops({op(eigenvals)})<>nops(eigenvals) then return(FAIL) end_if;
      sol:=Matrix(ExpressionField())(n,1);
      for lambda in eigenvals do
         userinfo(2,"for eigenvalue",lambda);
         m:=nops(select(eigenvals,_equal,lambda)); # dimension of eigenspace #
         if m<>1 then return(FAIL) end_if;
         userinfo(2,"dimension of eigenspace is",m);
         C:=A[0]+lambda*Id;
         eigenvects:=linalg::nullSpace(C);
         userinfo(2,"eigenvectors for value",lambda,"are",eigenvects);
         d:=0; # dimension of eigenspace #
         v:=eigenvects[1];
         for i from 1 to m do
            C:=genident("C"); lc:=append(lc,C);
            sol:=sol+C*z^(i-1)*exp(lambda*z)*v;
            if i=m then break end_if;
            v:=C*v; # see last formula on page 318 of [Zwillinger] #
         end_for;
      end_for;
      hsol:=[op(l,i)(z)=sol[i] $ hold(i)=1..n];
      if {op(b)}={0} then hsol # homogeneous system #
      else
         lc:=linsolve({_plus(A[1][i,j]*sol[j]$j=1..n)+b[i] $ hold(i)=1..n},{op(lc)});
         if type(lc)<>DOM_SET then
            userinfo(1,"unable to solve for integration constants");
            FAIL
         else 
            lc:=map(lc,func(op(eq,1)=op(eq,1)+int(op(eq,2),z),eq));
            map(subs(hsol,op(lc)),expand)
         end_if
      end_if
   else FAIL
   end_if
end_proc:
