# main function to solve a single differential equation eq=0 in y(z) 
  with initial conditions inits #
ode::solve_eq := proc(eq,y,z,inits)
local l,i;
begin
   if type(inits)<>DOM_SET then inits:={} end_if;
   if type(eq)="_equal" then eq:=op(eq,1)-op(eq,2) end_if;
   eq:=numer(eq);
   userinfo(1,"trying to factor");
   l:=factor(eq);
   _concat(ode::solve_eq_irred(l[2*i],y,z,inits) $ i=1..nops(l) div 2)
end_proc:

# returns a list of solutions or [] if no solution found #
ode::solve_eq_irred := proc(eq,y,z,inits)
local n,s,l,sol,yp,lhs,a,v,i,csts;
begin
   userinfo(1,"solving DE",eq);
   if not testtype(eq,Type::ODE(y,z)) then
      error("not an ordinary differential equation in the given variable")
   end_if;
   s:=ode::indets(eq,{y});
   if s={} then return([]) end_if;
   n:=max(op(map(s,ode::order)));
   userinfo(1,"ordinary differential equation of order",n);
   if n=0 then
      s:=subs(eq,y(z)=yp);
      return(solve(s,yp))
   end_if;
   sol:=ode::separate(eq,y,z,n);
   if sol=FAIL then
      l:=[diff(y(z),z$i)$i=0..n];
      if (l:=Type::Linear(eq,l))<>FALSE then sol:=ode::solve_linear(l,z,n,eq)
      else # non linear #
         userinfo(1,"non linear ordinary differential equation");
         sol:=ode::autonomous(eq,y,z,n);
         if sol=FAIL then sol:=ode::Bernoulli(eq,y,z) end_if;
      end_if
   end_if;
   userinfo(2,"solution is",sol);
   if sol=FAIL then return([]) # do not return FAIL because of _concat #
   elif inits={} then return(sol)
   end_if;
   userinfo(1,"trying to fulfill initial conditions");
   userinfo(2,"which are",inits);
   s:={};
   csts:=indets(sol) minus (indets(eq) union {y,z});
   for eq in inits do
      lhs:=op(eq,1); i:=0; a:=op(lhs); 
      lhs:=op(lhs,0); # should be y or D(...D(y)...) #
      case type(lhs)
      of DOM_IDENT do break
      of "D" do repeat lhs:=op(lhs); i:=i+1 until type(lhs)<>"D" end_repeat; break
      otherwise error("invalid initial conditions")
      end_case;
      if lhs<>y then error("invalid initial conditions") end_if;
      s := s union {[i,a,op(eq,2)]}; # [i,a,b] means (D@@i)(f)(a)=b #
   end_for;
   map(sol,ode::solvinit,s,csts,z)
end_proc:

# inits is a set of triples [i,a,b] #
ode::solvinit := proc(sol,inits,csts,z)
local s,t,i;
begin
   userinfo(3,"general solution is",sol);
   userinfo(3,"initial conditions are",inits);
   s:={};
   for t in inits do
      s := s union {eval(subs(diff(sol,z$t[1]),hold(int)=fun(0),z=t[2]))=t[3]};
   end_for;
   userinfo(3,"system to solve is",s);
   s:=solve(s,csts);
   s:=select(s,fun(contains({DOM_LIST,DOM_SET},type(args(1)))));
   userinfo(3,"solution is",s);
   if s=[] then null() # no solution #
   else # s is a list of solutions #
      sol:=subs(sol,op(op(s,i))) $ hold(i)=1..nops(s);
      if has(sol,{sin,cos}) then sol:=combine(expand(sol),sincos) end_if;
      sol
   end_if
end_proc:

