# solves the equation l[1]*y(z)+l[2]*diff(y(z),z)+...+l[n+1]*diff(y(z),z$n)+l[n+2]=0 #

ode::solve_linear := proc(l,z,n)
local inho,char_eq,X,i,j,k,sys,up,y,partsol,lc,gensol,yy;
begin
   userinfo(1,"linear ordinary differential equation");
   inho:=l[n+2]; l[n+2]:=NIL; lc:=l[n+1]; # leading coefficient #
   y:=FAIL;
   if not has(l,z) then
      userinfo(1,"with constant coefficients");
      char_eq:=_plus(l[i+1]*X^i $ i=0..n);
      userinfo(2,"solving characteristic equation",char_eq);
      l:=solve(char_eq,X);
      userinfo(2,"solutions are",l);
      if nops(l)<>n then return(FAIL) end_if;
      y:=ode::vspace(l,z);
   else
      userinfo(1,"with non constant coefficients");
      if n=1 then y:=[ode::firstord(l[1]*yy(z)+l[2]*diff(yy(z),z),yy,z)]
      end_if;
   end_if;
   if y=FAIL then y:=ode::undet(l,z) end_if;
   userinfo(2,"solution of homogeneous part is",y);
   if y=FAIL then return(ode::adjoint(l,z,inho)) end_if;
   if nops(y)<>n then return(y) end_if; # can happen after undet #
   gensol:=_plus(genident("C")*y[k] $ k=1..n);
   # a solution of the homogeneous part of the linear DE is C1*y[1]+...+Cn*y[n] #
   # we now find a particular solution of the full equation #
   # using the method described on page 314 of Zwillinger (Variation of parameters) #
   if inho=0 then partsol:=0
   else
      sys:={_plus(diff(y[k],z$i)*up[k] $ k=1..n) $ hold(i)=0..n-2,
		_plus(diff(y[k],z$(n-1))*up[k] $ k=1..n)+inho/lc};
      userinfo(2,"system to solve is",sys);
      sys:=linsolve(sys,{up[k] $ k=1..n});
      for i in sys do evalassign(op(i,1),op(i,2),1) end_for;
      for k from 1 to n do
         userinfo(2,"integrating",up[k]);
         up[k]:=int(up[k],z);
         userinfo(2,"solution is",up[k]);
      end_for;
      partsol:=_plus(up[k]*y[k] $ hold(k)=1..n);
   end_if;
   [gensol+expand(partsol)]
end_proc:

