# $Date: 1994/05/31 13:23:35 $  $Author: linus $  $Revision: 1.1 $ #

#++
chebyshev1(n, x) - generates the nth Chebyshev polynomial (first kind)
++#

#--
Chebyshev1(n, x) - recurrence relation for Chebyshev polynomials
--#

#--
computing Chebyshev polynomial T(n,x) by using the recurrence relation
T(0,x) = 1
T(1,x) = x
T(n,x) = 2 * x * T(n-1,x) - T(n-2,x) for n > 1
--#
orthpoly::chebyshev1 := proc(n,x)
local T;
begin
	if args(0) <> 2 
                then
                        error("wrong number of arguments!"); 
        end_if;

	if not (domtype(n) = DOM_INT)
		then 
			error("1st argument must be integer!");
	end_if;

	if n < 0 
		then
			error("1st argument must be positive!");
	end_if;
	
	if domtype(x) = DOM_IDENT
		then
			poly(orthpoly::Chebyshev1(n,x), [x], Expr);
		else
			poly(orthpoly::Chebyshev1(n,T), [T], Expr);
			evalp(%, T=x);
	end_if;
	%;
end_proc:

#--
recursive version for the Chebyshev polynomials of the first kind.
the result is an expression, not a polynomial

orthpoly::Chebyshev1 := proc(n,x)
local T;
option remember;
begin
	case n
		of 0 do
			T := 1;
			break;
		of 1 do 
			T := x;
			break;
		otherwise
			T := 2 * x * orthpoly::Chebyshev1(n-1,x) - orthpoly::Chebyshev1(n-2,x);
	end_case;
	T;
end_proc:
--#

#--
iterative version for the Chebyshev polynomials of the first kind.
the result is an expression, not a polynomial
--#

orthpoly::Chebyshev1 := proc(n,x)
local T,i;
begin
	case n
	   of 0 do
		T := 1;
		break;
	   of 1 do
		T := x;
		break;
	   otherwise
		1; x; 
		for i from 1 to n-1 do 
			expand(2*x * eval(%1) - eval(%2));
		end_for;	
		T := %;
	end_case;
	T
end_proc:

