# $Date: 1994/05/31 13:23:36 $  $Author: linus $  $Revision: 1.1 $ # 

#++
chebyshev2(n, x) - generates the nth Chebyshev polynomial of the second kind
++#

#--
Chebyshev2(n, x) - recurrence relation for Chebyshev polynomials
--#

#--
computing Chebyshev polynomial U(n,x) by using the recurrence relation
U(0,x) = 1
U(1,x) = 2*x
U(n,x) = 2 * x * U(n-1,x) - U(n-2,x) for n > 1
--#
orthpoly::chebyshev2 := proc(n,x)
local T;
begin
	if args(0) <> 2 
                then
                        error("wrong number of arguments!"); 
        end_if;

	if not (domtype(n) = DOM_INT)
		then 
			error("1st argument must be integer!");
	end_if;

	if n < 0 
		then
			error("1st argument must be positive!");
	end_if;
	
	if domtype(x) = DOM_IDENT
		then
			poly(orthpoly::Chebyshev2(n,x), [x], Expr);
		else
			poly(orthpoly::Chebyshev2(n,T), [T], Expr);
			evalp(%, T=x);
	end_if;
	%;
end_proc:

#--
the recursive part for the Chebyshev polynomials of the second kind.
the result is an expression, not a polynomial

orthpoly::Chebyshev2 := proc(n,x)
local T;
option remember;
begin
	case n
		of 0 do
			T := 1;
			break;
		of 1 do 
			T := 2*x;
			break;
		otherwise
			T := 2 * x * orthpoly::Chebyshev2(n-1,x) - orthpoly::Chebyshev2(n-2,x);
	end_case;
	T;
end_proc:
--#

#-- 
iterative version for the Chebyshev polynomials of the second kind. 
the result is an expression, not a polynomial 
--# 

orthpoly::Chebyshev2 := proc(n,x)
local T,i; 
begin
        case n 
           of 0 do 
                T := 1; 
                break; 
           of 1 do 
                T := 2*x; 
                break; 
           otherwise 
                1; 2*x;
                for i from 1 to n-1 do
                        expand(2*x * eval(%1) - eval(%2));
                end_for;
                T := %; 
        end_case;
        T
end_proc:
