# $Date: 1994/05/31 13:23:38 $  $Author: linus $  $Revision: 1.1 $ # 

#++
gegenbauer(n, a, x) - generates the nth Gegenbauer polynomial
++#

#--
Gegenbauer(n, a, x) - recurrence relation for Gegenbauer polynomials
--#

#--
computing Gegenbauer polynomial C(n,x) by using the recurrence relation
C(0,a, x) = 1
C(1,a, x) = 2*a*x
C(n,a, x) = 2 * (n+a-1)/n * x * C(n-1,a ,x) - (n+2*a-2)/n*C(n-2, a,x)
--#
orthpoly::gegenbauer := proc(n,a, x)
local T;
begin
	if args(0) <> 3 
		then 
			error("wrong number of arguments!");
	end_if;

	if not (domtype(n) = DOM_INT) 
		then 
			error("1st argument must be integer!");
	end_if;
	if n < 0 
		then
			error("1st argument must be positive!");
	end_if;

	if not (domtype(a) = DOM_INT) and not (domtype(a) = DOM_RAT)
		then
			error("2nd argument must be a rational number!");	
	end_if;

	if a <= -1/2 
		then
			error("2nd argument must be greater than -1/2!");
	end_if;
	
	if domtype(x) = DOM_IDENT
		then
			poly(orthpoly::Gegenbauer(n,a,x), [x], Expr);
		else
			poly(orthpoly::Gegenbauer(n,a,T), [T], Expr);
			evalp(%, T=x);
	end_if;
	%;
end_proc:

#--
the recursive part for the Gegenbauer polynomials.
the result is an expression, not a polynomial

orthpoly::Gegenbauer := proc(n,a,x)
local T;
option remember;
begin
	case n
		of 0 do
			T := 1;
			break;
		of 1 do 
			T := 2*a*x;
			break;
		otherwise
			T := 2 * (n+a-1)/n * x * orthpoly::Gegenbauer(n-1,a ,x) - (n+2*a-2)/n*orthpoly::Gegenbauer(n-2, a,x);
	end_case;
	T;
end_proc:
--#

#--
iterative version of computing  Gegenbauer polynomials.
the result is an expression, not a polynomial
--#
orthpoly::Gegenbauer := proc(n,a,x)
local T;
begin
        case n
           of 0 do
                T := 1;
                break;
           of 1 do
                T := 2*a*x;
                break;
           otherwise
                1; 2*a*x;
                for i from 1 to n-1 do
			expand(2*(a+i)/(i+1)*x*eval(%1) - (2*a + i-1)/(i+1)*eval(%2));
                end_for;
                T := %;
        end_case;
        T
end_proc:
