# $Date: 1994/05/31 13:23:39 $  $Author: linus $  $Revision: 1.1 $ # 

#++
hermite(n, x) - generates the nth Hermite polynomial
++#

#--
Hermite(n, x) - recurrence relation for Hermite polynomials
--#

#--
computing Hermite polynomial H(n,x) by using the recurrence relation
H(0,x) = 1
H(1,x) = 2*x
H(n,x) = 2*x*H(n-1,x) - 2*(n-1)*H(n-2,x) for n > 1
--#
orthpoly::hermite := proc(n,x)
local T;
begin
	if args(0) <> 2
                then
                        error("wrong number of arguments!");
        end_if;

	if not (domtype(n) = DOM_INT) 
		then 
			error("1st argument must be integer!");
	end_if;

	if n < 0 
		then
			error("1st argument must be positive!");
	end_if;
	
	if domtype(x) = DOM_IDENT
		then
			poly(orthpoly::Hermite(n,x), [x], Expr);
		else
			poly(orthpoly::Hermite(n,T), [T], Expr);
			evalp(%, T=x);
	end_if;
	%;
end_proc:

#--
the recursive part for the Hermite polynomials.
the result is an expression, not a polynomial

orthpoly::Hermite := proc(n,x)
local T;
option remember;
begin
	case n
		of 0 do
			T := 1;
			break;
		of 1 do 
			T := 2*x;
			break;
		otherwise
			T := 2 * x * orthpoly::Hermite(n-1,x) - 2 * (n-1)*orthpoly::Hermite(n-2,x);
	end_case;
	T;
end_proc:
--#

#-- 
iterative version of computing  Gegenbauer polynomials. 
the result is an expression, not a polynomial 
--# 
orthpoly::Hermite := proc(n,x)
local T,i; 
begin  
        case n   
           of 0 do
                T := 1;  
                break;
           of 1 do   
                T := 2*x;  
                break;    
           otherwise 
                1; 2*x;
                for i from 1 to n-1 do
                        expand(2*x*eval(%1) - 2*i*eval(%2));
                end_for;   
                T := %;
        end_case;
        T
end_proc:
