# implicit 2-dimensional plot
  
  Syntax: implicitplot(f,rx,ry <,n>)

  f : procedure or function with two parameters
  rx,ry : ranges
  n : integer (optional)

  The algorithm used is the BisectEx algorithm of
  Jean-Pierre Dedieu and Jean-Claude Yakoubsohn,
  see Numerical Algorithms, 4 (1993), pages 1-24.
#

plotlib::implicitplot := proc(f,rx,ry,n) # f is a fun, rx, ry are ranges, n an integer #
begin
   loadlib("domains");
   if args(0)<4 then n:=6 end_if; # default depth #
   plot2d([Mode=List,[plotlib::bisect(f,Interval(rx),Interval(ry),n)]])
end_proc:

plotlib::bisect := proc(f,ix,iy,n) local v,mx,my,xl,xr,yl,yr;
begin
   v:=Interval::sign(f(ix,iy));
   if v<>0 then null() # exclusion #
   else
      if n=0 then
        xl:=extop(ix,1); xr:=extop(ix,2);
	yl:=extop(iy,1); yr:=extop(iy,2);
	polygon(point(xl,yl),point(xr,yl),point(xr,yr),Filled=TRUE),
	polygon(point(xl,yl),point(xl,yr),point(xr,yr),Filled=TRUE)
      else # bisection #
         mx:=_plus(extop(ix))/2; my:=_plus(extop(iy))/2;
         xl:=extsubsop(ix,2=mx); xr:=extsubsop(ix,1=mx);
	 yl:=extsubsop(iy,2=my); yr:=extsubsop(iy,1=my);
	 plotlib::bisect(f,xl,yl,n-1), plotlib::bisect(f,xl,yr,n-1),
	 plotlib::bisect(f,xr,yl,n-1), plotlib::bisect(f,xr,yr,n-1)
      end_if
   end_if
end_proc:

