#
| plotlib::sphericalplot - generates graphics in spherical coordinates
|
| args                   - <scene_options ,> object_1 <, object_2, ...>
|
|                        Hereby the <scene_options> describes the options
|                        which can be set in order to influence the whole
|                        graphics (like Scaling). These options are optio-
|                        nal. All options listed in the reference manual
|                        can be used here.
|
|                        object_i is used to specify the i-th object of
|                        the current graphics. This is to be given in form
|                        of a list:
|
|                        [[r, phi, theta], 
|                             phi = [pmin, pmax], theta = [tmin, tmax], 
|                             options]
|
|                        r       - radius
|                        phi     - describes the horicontal angle
|                        theta   - describes the vertical angle
|                        pmin    - minimum value for the range in which phi
|                                  is evaluated
|                        pmax    - maximum value for the range in which phi
|                                  is evaluated
|                        tmin    - minimum value for the range in which 
|                                  theta is evaluated
|                        tmax    - maximum value for the range in which 
|                                  theta is evaluated
|                        options - used to influence the graphical represen-
|                                  tation of the object. All options listed
|                                  for plot3d() in the reference manual can
|                                  be used here.
#
plotlib::sphericalplot := proc()
    local i, j, list, s, DIGITS, fsin, fcos;
begin
    fsin := funcattr(sin, "float"):
    fcos := funcattr(cos, "float"):

    if args(0) = 0 then 
        plot(Dimension = 3)
    else 
        for i from 1 to args(0) do 
            list[i]:=args(i); 
            if 2 <= nops(op(list[i], 1)) then 
                list[i]:=subsop(list[i], [1] = 
                                (Mode = Surface,
                                [op(list[i],[1,1])*fcos(op(list[i],[1,2]))
                                                  *fsin(op(list[i],[1,3])),
                                 op(list[i],[1,1])*fsin(op(list[i],[1,2]))
                                                  *fsin(op(list[i],[1,3])),
                                 op(list[i],[1,1])*fcos(op(list[i],[1,3]))])):
            end_if; 
        end_for; 
        plot3d(list[j] $ j = 1..nops(list))
    end_if
end_proc:
