gfun:=domain():
gfun::name:="gfun":
gfun::info:="Library Gfun: manipulation of holonomic functions and recurrences":
gfun::interface:={hold(diffeqtorec),hold(rattaylor)}:

# typ is "rec" or "diffeq"
    eq is the recurrence or the diffential equation
    inits is a set of initials conditions
    u is the name of the recurrence or the function
    n is the index of the recurrence or the differential variable #
gfun::new := proc(typ,eq,inits,u,n)
begin
   if type(eq)="_equal" then eq:=op(eq,1)-op(eq,2) end_if;
   new(gfun,typ,eq,inits,u,n)
end_proc:

gfun::print := proc(a)
begin
   if extop(a,1)="rec" then
      hold(Rec)({extop(a,2)} union extop(a,3))
   else
      Deq({extop(a,2)} union extop(a,3))
   end_if
end_proc:

gfun::diffeqtorec := proc(a)
local deq,y,x,rec;
begin
   if extop(a,1)<>"deq" then error("not a differential equation") end_if;
   y:=extop(a,4); x:=extop(a,5);
   deq := expand(extop(a,2));
   if type(deq)="_plus" then rec:=map(deq,gfun::dtr,y,x);
   else rec:=gfun::dtr(deq,y,x)
   end_if;
   normal(extsubsop(a,1="rec",2=rec,3={}))
end_proc:

gfun::dtr := proc(t,y,x) # c x^k diff(y(x),x$j) #
local c,k,j;
begin
   k := degree(t,x);
   if has(t,y) then
      j := gfun::difforder(t,y,x);
      c := t/x^k/diff(y(x),x$j);
      if has(c,x) or has(c,y) then error("gfun::dtr") end_if;
      c*_mult(x+i$i=1-k..j-k)*y(x+j-k)
   else # c*x^k #
      0
   end_if
end_proc:

gfun::difforder := proc(t,y,x)
begin
   case type(t) 
   of "diff" do if op(t,1)=y(x) then return(nops(t)-1) else return(0) end_if;
   of "_plus" do return(max(op(map([op(t)],gfun::difforder,y,x))));
   of "_mult" do return(_plus(op(map([op(t)],gfun::difforder,y,x))));
   of DOM_INT do return(0);
   of DOM_IDENT do return(0);
   of "function" do return(0);
   of "_power" do return(gfun::difforder(op(t,1),y,x)^op(t,2))
   otherwise print(t); error("")
   end_case
end_proc:

gfun::rattorec := proc(e,y,x,n)
# transforms a rational expression in x into a linear recurrence #
local p,q,m,i,init,c,s,valq,rec;
option remember;
begin
   p:=numer(e); q:=denom(e);
   if type(q)="_plus" then rec:=map(q,gfun::rattorec2,y,n)
   else rec:=gfun::rattorec2(q,y,n)
   end_if;
   # q is now the recurrence #
   # initial conditions up to max(deg(q)-1,deg(p)) #
   m := max(degree(q,[x])-1,degree(p,[x]));
   valq:=0; while coeff(q,[x],valq)=0 do valq:=valq+1 end_while; 
   s := p-expand(q*_plus(y.i*x^i$i=0..m));
   init := array(0..m);
   for i from valq to valq+m do
      c:=coeff(s,[x],i);
      init[i]:=-coeff(c,[y.i],0)/coeff(c,[y.i],1);
      s := subs(s,y.i=init[i]);
   end_for;
   op(init),rec
end_proc:

gfun::rattorec2 := proc(m,y,n) # m = c * x^k #
begin
   content(m,[x])*y[n-degree(m,[x])];
end_proc:

gfun::rattaylor := proc(e,x,n)
local y,s,t,k,i,eq,m,o;
begin
   s := [gfun::rattorec(e,y,x,m)];
   k := nops(s)-1; # number of initial conditions #
   if n<=k then 
	# _plus((s[i+1]*x^i)$i=0..n-1)+O(x^n) #
        Puiseux::create(1,0,n,[s[i]$i=0..n-1],x)
   else
      t := array(0..n-1);
      for i from 0 to k-1 do t[i]:=s[i+1] end_for;
      eq := s[k+1]; # recurrence equation #
      o := gfun::maxindex(eq,y,m);
      eq := -coeff(eq,[y[m+o]],0)/coeff(eq,[y[m+o]],1);
      if o<>0 then eq:=subs(eq,m=m-o) end_if;
      eq := subs(eq,y=hold(t));
      # now eq gives y(m) in terms of y(m-1), y(m-2), ... #
      for i from k to n-1 do t[i]:=eval(subs(eq,m=i)) end_for;
      # _plus(t[i]*x^i$hold(i)=0..n-1)+O(x^n) #
      Puiseux::create(1,0,n,[t[i]$hold(i)=0..n-1],x)
   end_if  
end_proc:

gfun::maxindex := proc(eq,y,n)
local t;
option remember;
begin
   if type(eq)="_plus" then max(seq(gfun::maxindex(t,y),t=eq))
   elif type(eq)="_mult" then _plus(seq(gfun::maxindex(t,y),t=eq))
   elif type(eq)="_index" and op(eq,1)=y then coeff(op(eq,2),[n],0)
   else 0
   end_if
end_proc:

# returns ord,rec' where rec' is of the form a[0]*u(n)+...+a[ord]*u(n+ord)=b #
gfun::recorder:=proc(rec,u,n)
local t,lo,hi,i;
option remember;
begin
   lo:=FAIL;
   for t in indets(rec,PolyExpr) do
      if op(t,0)=u then
         i:=op(t)-n;
         if type(i)=DOM_INT then
            if lo=FAIL then lo:=i; hi:=i
            elif i<lo then lo:=i
            elif i>hi then hi:=i
            end_if
         end_if
      end_if
   end_for;
   if lo=FAIL then error("invalid recurrence")
   else hi-lo,expand(subs(rec,n=n-lo))
   end_if
end_proc:

gfun::recplusrec := proc(a,b)
local u,n,v,m,rec,l,ord1,ord2,ord,i,f,g,h,unks,rec1,rec2,inits,ui,vi,inits1,inits2;
begin
   rec1:=extop(a,2); rec2:=extop(b,2);
   u:=extop(a,4); n:=extop(a,5);
   v:=extop(b,4); m:=extop(b,5);
   # compute orders and normalize recurrences #
   l:=gfun::recorder(rec1,u,n); ord1:=l[1]; 
   rec1:=subs(-coeff(l[2],u(n+ord1),0)/coeff(l[2],u(n+ord1),1),u=f);
   l:=gfun::recorder(rec2,v,m); ord2:=l[1]; 
   rec2:=subs(-coeff(l[2],v(m+ord2),0)/coeff(l[2],v(m+ord2),1),v=g,m=n);
   h[n]:=f(n)+g(n); unks:={f(n),g(n)}; 
   tosubs:=null();
   for i from 1 to ord1+ord2 do
      h[n+i]:=subs(h[n+i-1],n=n+1,f(n+ord1)=rec1,g(n+ord2)=rec2);
      for l in indets(h[n+i],PolyExpr) do
         if type(l)="function" then
            if contains({f,g},op(l,0)) and has(op(l),n) then unks:=unks union {l} end_if
         end_if
      end_for;
      if i+1>nops(unks) then break end_if
   end_for;
   rec:=gfun::lindep([h[n+l]-u(n+l)$hold(l)=0..i],unks);
   ord:=gfun::recorder(rec)[1];
   inits1:=gfun::getinits(a,ord-1); 
   inits2:=gfun::getinits(b,ord-1);
   inits:=null();
   for i from 0 to ord-1 do
      l:=subs(u(i),inits1)+subs(v(i),inits2);
      if not has(l,{u,v}) then inits:=inits,u(i)=l end_if
   end_for;
   normal(extsubsop(a,2=rec,3={inits}))
end_proc:

# gets the initial value from 0 to k #
gfun::getinits:=proc(a,k) local i,ui,rec,u,n,inits,ord,l;
begin
   inits:=op(extop(a,3)); u:=extop(a,4); n:=extop(a,5);
   l:=gfun::recorder(extop(a,2),u,n); ord:=l[1];
   rec:=-coeff(l[2],u(n+ord),0)/coeff(l[2],u(n+ord),1);
   l:=null();
   for i from 0 to k do
      ui:=subs(u(i),inits);
      if has(ui,u) then
         ui:=subs(subs(rec,n=i-ord),inits,l);
      end_if;
      if not has(ui,u) then l:=l,u(i)=ui end_if
   end_for;
   l
end_proc:

gfun::diffeq_mult_diffeq := proc(a,b)
local u,x,v,z,deq,l,ord1,ord2,i,f,g,h,unks,deq1,deq2;
begin
   deq1:=extop(a,2); deq2:=extop(b,2);
   u:=extop(a,4); x:=extop(a,5);
   v:=extop(b,4); z:=extop(b,5);
   # compute orders and normalize recurrences #
   ord1:=gfun::difforder(deq1,u,x);
   i:=diff(u(x),x$ord1);
   deq1:=subs(i=-coeff(deq1,i,0)/coeff(deq1,i,1),u=f);
   ord2:=gfun::difforder(deq2,v,z);
   i:=diff(v(z),z$ord2);
   deq2:=subs(i=-coeff(deq2,i,0)/coeff(deq2,i,1),v=g,z=x);
   h[n]:=f(z)*g(z); unks:={f(z),g(z)}; 
   tosubs:=null();
   for i from 1 to ord1+ord2 do
      h[n+i]:=subs(diff(h[n+i-1],x),deq1,deq2);
      for l in indets(h[n+i],PolyExpr) do
         if type(l)="diff" then
            if contains({f,g},op(l,1)) and has(l,x) then unks:=unks union {l} end_if
         end_if
      end_for;
      if i+1>nops(unks) then break end_if
   end_for;
   rec:=gfun::lindep([h[n+l]-diff(u(x),x$l)$hold(l)=0..i],unks);
   new(gfun,"rec",rec,{},u,n)
end_proc:

gfun::lindep:=proc(l,unks)
local i,eq,s,x,tosubs,j;
begin
   tosubs:=[];
   for i from 1 to nops(l) do
      eq:=l[i];
      for j in tosubs do 
         eq:=numer(subs(eq,j))
      end_for;
      s:=indets(eq,PolyExpr) intersect unks;
      if s={} then return(eq/content(eq))
      else
         x:=op(s,1);
         tosubs:=append(tosubs,x=-coeff(eq,x,0)/coeff(eq,x,1));
      end_if
   end_for;
   error("not enough equations")
end_proc:

gfun::_plus := proc(a,b)
begin
   if extop(a,1)="rec" and extop(b,1)="rec" then
      gfun::recplusrec(a,b)
   end_if
end_proc:

gfun::negate:=proc(a)
local u;
begin
   u:=extop(a,4);
   extsubsop(a,2=eval(subs(extop(a,2),u=-u)),
      3=map(extop(a,3),proc(eq) begin op(eq,1)=-op(eq,2) end_proc))
end_proc:

gfun::rectodiffeq:=proc(a)
local deq,rec;
begin
   if extop(a,1)<>"rec" then error("not a recurrence") end_if;
   rec:=expand(numer(extop(a,2)));
   if type(rec)="_plus" then deq:=map(rec,gfun::rtd,extop(a,4),extop(a,5))
   else deq:=gfun::rtd(rec,extop(a,4),extop(a,5))
   end_if;
   normal(extsubsop(a,1="deq",2=deq,3={}))
end_proc:

# outputs the g.f. in x whose coeff. of x^k = n^k,
   for example k=0 ==> 1/(1-x),
                       k=1 ==> x/(1-x)^2 #
gfun::ntok:=proc(x,k)
option remember;
begin
   if k=0 then 1/(1-x)
   else x*diff(gfun::ntok(x,k-1),x)
   end_if
end_proc:

gfun::normal:=proc(a) local l,eq,i,u,n,g,c;
begin
   a:=extsubsop(a,2=numer(extop(a,2)));
   u:=extop(a,4); n:=extop(a,5);
   if type(a)="rec" then 
      l:=gfun::recorder(extop(a,2),u,n);
      eq:=[]; g:=0;
      for i from 0 to l[1] do
         c:=coeff(l[2],u(n+i),1);
         g:=gcd(g,c);
         eq:=append(eq,c);
         l[2]:=subs(l[2],u(n+i)=0);
      end_for;
      g:=gcd(g,l[2]);  # inhomogeneous terms #
      if g<>1 then
         eq:=map(eq,divide,g,Exact);
         l[2]:=divide(l[2],g,Exact); 
      end_if;
      eq:=_plus(eq[i+1]*u(n+i)$hold(i)=0..l[1])+l[2];
      extsubsop(a,2=eq)
   else # deq #
      eq:=extop(a,2);
      g := proc(v) begin bool(type(v)="function" and op(v,0)=u or type(v)="diff") end_proc;
      l:=select(indets(eq,PolyExpr),g);
      extsubsop(a,2=normal(eq/content(eq,[op(l)])))
   end_if;
end_proc:

gfun::rtd:=proc(t,u,n) # t = c*n^k*u(n+i) or t = c*n^k #
local l,k,i,c,f;
begin
   f := proc(v) begin bool(type(v)="function" and op(v,0)=u) end_proc;
   l:=select(indets(t,PolyExpr),f);
   if l={} then # t = c*n^k = [x^n] c*(Theta@@k)(1/(1-x)) #
      k:=degree(t,n);
      c:=t/n^k;
      if has(c,n) then error("wrong term") end_if;
      c*gfun::ntok(n,k)
   else # (Theta@@k)(y(x)/x^i) #
      if nops(l)<>1 then error("wrong term") end_if;
      i:=op(op(l,1))-n;
      t:=t/u(n+i);
      k:=degree(t,n);
      c:=t/n^k;
      f:=u(n)/n^i;
      while k>0 do f:=n*diff(f,n); k:=k-1 end_while;
      c*f
   end_if
end_proc:

gfun::type:=proc(a) begin extop(a,1) end_proc:

gfun::cauchy:=proc(a,b)
begin
   case type(a),type(b)
   of "rec","rec" do
      a:=gfun::rectodiffeq(a); b:=gfun::rectodiffeq(b);
      a:=gfun::diffeq_mult_diffeq(a,b);
      return(gfun::diffeqtorec(a))
   otherwise error("not yet implemented")
   end_case
end_proc:

#
rec1:=gfun::new("rec",u(n)=-u(n-1)/(d-n)/n*(d-n+1),{u(0)=1/d},u,n):
rec2:=gfun::new("rec",u(n)=u(n-1)/n,{u(0)=1},u,n):

deq1:=gfun::rectodiffeq(rec1):
deq2:=gfun::rectodiffeq(rec2):
#
