Series::series := proc()
local res;
begin
   if traperror((res:=Series::Puiseux(args())))=0 then res else FAIL end_if
end_proc:

Series::Puiseux := proc(f,x,n)
local tf,p,s;
begin
   userinfo(2,"computing expansion of",f);
   if testtype(f,Type::PolyExpr(x,Type::AnyType)) then Puiseux::frompoly(poly(f,[x]),n,x)
   # f rational -> O(n) recurrence,
     but use this only for high order because of the overhead #
   elif (n>=200) and  testtype(f,Type::RatExpr(x,Type::AnyType)) then    
      gfun::rattaylor(f,x,n)
   else
      tf:=type(f); # "exp" or "tan" or ... #
      # first catch functions with variable number of arguments #
      if tf="_plus" then Series::plus(f,x,n)
      elif tf="_mult" then Series::mult(f,x,n)
      elif tf="_power" then Series::power(op(f),x,n)
      else
         p := op(f,0);
         if domtype(level(p,2)) = DOM_FUNC_ENV then 
            p:=funcattr(level(p,2),"series");
	    if type(p)=DOM_PROC then return(p(op(f),x,n)) end_if;
	 end_if;
         Series::unknown(f,x,n)
      end_if
   end_if
end_proc:

Series::unknown := proc(_f_,x,n)
local g,fa,i,g0,l;
begin
   fa:=1;
   g:=_f_;
   if type(g)="int" then g0:=0 else g0:=subs(g,x=0) end_if;
   l:=[g0];
   for i from 1 to n-1 do
      g:=diff(g,x);
      g:=Series::diff2D(g);
      fa:=fa*i;
      l:=append(l,subs(g,x=0)/fa);
   end_for;
   Puiseux::create(1,0,n,l,x)
end_proc:

Series::diff2D := proc(_f) 
begin
   case type(_f)
   of "_plus" do
   of "_mult" do
   of "_power" do return(map(_f,Series::diff2D))
   of "diff" do return(_fconcat(D$nops(_f)-1)(op(_f,[1,0]))(op(_f,[1,1]))*
				Series::diff2D(diff(op(_f,[1,1]),op(_f,2))))
   end_case;
   _f
end_proc:

Series::plus:=proc(f,x,n) # f is a sum #
local s,i;
begin
   s:=Series::Puiseux(op(f,1),x,n);
   for i from 2 to nops(f) do s:=s+Series::Puiseux(op(f,i),x,n) end_for;
end_proc:

Series::mult:=proc(f,x,n) # f is a product #
local s,i,k;
begin
   k:=select(f,fun(not has(args(1),x)));
   if k=f then Puiseux::create(1,0,n,[f],x) # does not depend on x #
   else
      f:=f/k;
      if type(f)<>"_mult" then s:=Series::Puiseux(f,x,n)
      else
	 s:=Series::Puiseux(op(f,1),x,n);
	 for i from 2 to nops(f) do
	    s:=s*Series::Puiseux(op(f,i),x,n)
	 end_for;
      end_if;
      s::scalmult(s,k)
   end_if
end_proc:

Series::power:=proc(a,b,x,n)
begin
   case type(b)
   of DOM_INT do
   of DOM_RAT do return(Puiseux::_power(Series::Puiseux(a,x,n),b))
   otherwise Series::Puiseux(hold(exp)(b*ln(a)),x,n) # to avoid infinite loops #
   end_case
end_proc:

Series::TEMPLATE:=proc(f,x,n) local s;
begin
   s:=Puiseux::create(1,START,n,Series::gen[MODEL](n),x);
   if f=x then s
   else
      Puiseux::_fconcat(s,Series::Puiseux(f,x,n))
   end_if
end_proc:

sin:=funcattr(sin,"series",proc(f,x,n) local s,t,k,a;
   name Series::sin;
begin
   if f=x then Puiseux::create(1,1,n,Series::gen["sin"](n),x)
   else
      t:=Series::Puiseux(f,x,n);
      k:=ldegree(t);
      if k>0 then Puiseux::_fconcat(Puiseux::create(1,1,n,Series::gen["sin"](n),x),t)
      elif k=0 then
         a:=lcoeff(t);
         # sin(a+t)=sin(a)*cos(t)+cos(a)*sin(t) #
         t:=f-a;
         sin(a)*series(cos(t),x,n)+cos(a)*series(sin(t),x,n)
      else error("unable to compute series expansion")
      end_if
   end_if
end_proc):

cos:=funcattr(cos,"series",proc(f,x,n) local s,t,k,a;
   name Series::cos;
begin
   if f=x then Puiseux::create(1,0,n,Series::gen["cos"](n),x)
   else
      t:=Series::Puiseux(f,x,n);
      k:=ldegree(t);
      if k>0 then Puiseux::_fconcat(Puiseux::create(1,0,n,Series::gen["cos"](n),x),t)
      elif k=0 then
         a:=lcoeff(t);
         t:=f-a;
         cos(a)*series(cos(t),x,n)-sin(a)*series(sin(t),x,n)
      else error("unable to compute series expansion")
      end_if
   end_if
end_proc):

sinh:=funcattr(sinh,"series",proc(f,x,n) local s,t,k,a;
   name Series::sinh;
begin
   if f=x then Puiseux::create(1,1,n,Series::gen["sinh"](n),x)
   else
      t:=Series::Puiseux(f,x,n);
      k:=ldegree(t);
      if k>0 then Puiseux::_fconcat(Puiseux::create(1,1,n,Series::gen["sinh"](n),x),t)
      elif k=0 then
         a:=lcoeff(t);
         t:=f-a;
         sinh(a)*series(cosh(t),x,n)+cosh(a)*series(sinh(t),x,n)
      else error("unable to compute series expansion")
      end_if
   end_if
end_proc):

cosh:=funcattr(cosh,"series",proc(f,x,n) local s,t,k,a;
   name Series::cosh;
begin
   if f=x then Puiseux::create(1,0,n,Series::gen["cosh"](n),x)
   else
      t:=Series::Puiseux(f,x,n);
      k:=ldegree(t);
      if k>0 then Puiseux::_fconcat(Puiseux::create(1,0,n,Series::gen["cosh"](n),x),t)
      elif k=0 then
         a:=lcoeff(t);
         t:=f-a;
         cosh(a)*series(cosh(t),x,n)+sinh(a)*series(sinh(t),x,n)
      else error("unable to compute series expansion")
      end_if
   end_if
end_proc):

exp:=funcattr(exp,"series",proc(f,x,n)
name Series::exp;
local s,f0,t,v,K;
begin
   s:=Puiseux::create(1,0,n,Series::gen["exp"](n),x);
   if f=x then s
   else
      t:=Series::Puiseux(f,x,n);
      if (v:=Puiseux::ldegree(t))<0 then # exp(1/x^a) #
	 gseries::new(exp(f),x,n) # try MRVasympt #
      elif v=0 then # exp(f0+(f-f0)) = exp(f0)*exp(f-f0) #
         f0:=Puiseux::lcoeff(t);
         if has(f0,x) then
            if has(f0,ln(x)) then
               if testtype((K:=f0/ln(x)),Type::Constant) then
                  t:=Puiseux::_fconcat(s,Puiseux::remove_head(t)); # exp(rest) #
                  if type(K)=DOM_INT then t:=Puiseux::scalmult(t,1,K)
                  else # generalized series #
                     t:=gseries::convert(extsubsop(t,5=x));
                     t:=gseries::scalmult(t,1,x^K);
                  end_if;
                  return(t)
               end_if
            end_if;
            error("invalid expansion") # to avoid exp(ln(x)^2) #
         end_if; 
         Puiseux::scalmult(Puiseux::_fconcat(s,Puiseux::remove_head(t)),exp(f0))
      else # v>0 #
         Puiseux::_fconcat(s,t)
      end_if;
   end_if
end_proc):

tan:=funcattr(tan,"series",proc(f,x,n) name Series::tan; begin series(sin(f),x,n)/series(cos(f),x,n) end_proc):
tanh:=funcattr(tanh,"series",proc(f,x,n) name Series::tanh; begin series(sinh(f),x,n)/series(cosh(f),x,n) end_proc):
asin:=funcattr(asin,"series",subs(Series::TEMPLATE,MODEL="asin",START=1)):
atan:=funcattr(atan,"series",subs(Series::TEMPLATE,MODEL="atan",START=1)):
atanh:=funcattr(atanh,"series",subs(Series::TEMPLATE,MODEL="atanh",START=1)):

acot:=funcattr(acot,"series",subs(Series::TEMPLATE,MODEL="acot",START=0)):

acosh:=funcattr(acosh,"series",proc(f,x,n)
   name Series::acosh;
begin
   error("No Puiseux expansion at the origin")
end_proc):

acoth:=funcattr(acoth,"series",subsop(funcattr(acosh,"series"),6=hold(Series::acoth))):

ln:=funcattr(ln,"series",proc(f,x,n) name Series::ln; local s,t,a,k;
begin
   s:=Puiseux::create(1,1,n,Series::gen["ln"](n),x);
   if f=1+x then s
   else
      t:=Series::Puiseux(f,x,n);
      k:=Puiseux::ldegree(t);
      a:=Puiseux::lcoeff(t);
      if k=0 then
         if a<>1 then t:=Puiseux::scalmult(t,1/a) end_if;
         # better than t - 1 which does not work for floating-points #
         ln(a)+Puiseux::_fconcat(s,t::remove_head(t)) 
      else
         t:=Puiseux::remove_head(t);
         t:=Puiseux::scalmult(t,1/a,-k); # t <- t/(a*x^k) #
         t:=Puiseux::_fconcat(s,t);
         t+Puiseux::create(1,0,Puiseux::order(t),[ln(a)+k*ln(x)],x)
      end_if
   end_if
end_proc):

cot:=funcattr(cot,"series",proc(f,x,n) 
   name Series::cot;
begin 
   f:=Series::Puiseux(tan(f),x,n);
   Puiseux::invert(f)
end_proc):
# csc(x) is automatically converted to 1/sin(x) #
# sec(x) is automatically converted to 1/cos(x) #
coth:=funcattr(coth,"series",proc(f,x,n) name Series::coth;
begin f:=Series::Puiseux(tanh(f),x,n); Puiseux::invert(f) end_proc):
# csch(x) is automatically converted to 1/sinh(x) #
# sech(x) is automatically converted to 1/cosh(x) #

Series::gen["exp"]:=proc(n) local t,i;
begin
   t:=1; [1,(t:=t/i)$i=1..n-1]
end_proc:
Series::gen["exp"](0):=[]:

Series::gen["erfc"]:=proc(n) local t,i;
begin
   t:=1/sqrt(PI);
   [t,(0,(t:=-t*(2*i-1)/2))$i=1..(n-1) div 2]
end_proc:

# expansion for ln(1+x) #
Series::gen["ln"]:=proc(n) local t,i;
begin
   t:=-1; [((t:=-t)/i$i=1..n-1)]
end_proc:

Series::gen["cos"]:=proc(n) local i,t;
begin
   t:=1; 
   [1,(0,(t:=-t/(2*i-1)/(2*i)))$i=1..(n-1) div 2]
end_proc:
Series::gen["cos"](0):=[]:

Series::gen["cosh"]:=proc(n) local i,t;
begin
   t:=1; 
   [1,(0,(t:=t/(2*i-1)/(2*i)))$i=1..(n-1) div 2]
end_proc:
Series::gen["cosh"](0):=[]:

Series::gen["sin"]:=proc(n) local i,t;
begin
   t:=1;
   [1,(0,(t:=-t/(2*i)/(2*i+1)))$i=1..(n-2) div 2]
end_proc:
Series::gen["sin"](0):=[]:
Series::gen["sin"](1):=[]:

Series::gen["sinh"]:=proc(n) local i,t; # 0.9s pour n=100 #
begin
   t:=1;
   [1,(0,(t:=t/(2*i)/(2*i+1)))$i=1..(n-2) div 2]
end_proc:
Series::gen["sinh"](0):=[]:
Series::gen["sinh"](1):=[]:

Series::gen["acot"]:=proc(n) local a,i; # 0.7s for n=100 #
begin
   a:=-1;
   [PI/2,a,(0,(a:=-a)/(2*i+1))$i=1..(n div 2)-1]
end_proc:
Series::gen["acot"](0):=[]:
Series::gen["acot"](1):=[PI/2]:

Series::gen["atan"]:=proc(n) local a,i; # 0.7s for n=100 #
begin
   a:=1;
   [a,(0,(a:=-a)/(2*i+1))$i=1..(n div 2)-1]
end_proc:
Series::gen["atan"](0):=[]:
Series::gen["atan"](1):=[]:

Series::gen["atanh"]:=proc(n) local i; # 0.7s for n=100 #
begin
   [1,(0,1/(2*i+1))$i=1..(n div 2)-1]
end_proc:
Series::gen["atanh"](0):=[]:
Series::gen["atanh"](1):=[]:

Series::gen["asin"]:=proc(n) local a,i; #  1.6s for n=100 #
begin
   a:=1;
   [a,(0,(a:=a*(2*i-1)/2/i)/(2*i+1))$i=1..(n div 2)-1]
end_proc:
Series::gen["asin"](0):=[]:
Series::gen["asin"](1):=[]:

# acsc(x) automatically simplified into asin(1/x) #

# asec(x) automatically simplified into acos(1/x) #

# acsch(x) automatically simplified into asinh(1/x) #


