#++
  Dirk Vogelsang
  jamesb@uni-paderborn.de

  help_edit() 
  Script for generating MuPAD help pages.                      
++#

sharelib::help_edit:=proc()

local fullstring, input, exc_underline, spec_char_test, warning,
      char_test_2, return_kill, index_make, make_crossref, none,
      list, sequence, both, meta, meta_out;

begin

fullstring:="":
fullstring:=fullstring."\\def\\singlemode{1}\n":
fullstring:=fullstring."% singlemode=0 - Hypermode-Aus\n":
fullstring:=fullstring."% singlemode=1 - Hypermode-Ein\n":
fullstring:=fullstring."\\ifnum\\singlemode=0\n":
fullstring:=fullstring."\\documentstyle[11pt,fleqn,longtable,verbatimwrite,hypertex,sprach]{mubook}\n":
fullstring:=fullstring."\\else\n":
fullstring:=fullstring."\\documentstyle[fleqn,longtable,verbatimwrite,hypertex,sprach]{mubook}\n":
fullstring:=fullstring."\\fi\n\n":

input:=proc(param)
local TEXTWIDTH,text;
begin
  text:="":
  TEXTWIDTH:=64000:
  textinput("EINGABE :",text):
end_proc:

exc_underline:=proc()
local h_t,i,z;
begin
 h_t:=text2list(f_name,["_"]):
 z:=nops(h_t):
 for i from 1 to z do 
	if h_t[i]="_" then h_t[i]:="\\mupunderbar{}" end_if:
 end_for:
 alt_f_name:="":
 for i from 1 to z do alt_f_name:=alt_f_name.h_t[i] end_for;
end_proc: 


spec_char_test:=proc()
begin
 if strmatch(f_name,"\*_\*") then 
	exc_underline():  
	spec_char:=TRUE:
 else
	f_name:
	alt_f_name:=f_name:
	spec_char:=FALSE:
 end_if: 
end_proc:

warning:=proc(string)
begin
 if (strmatch(string,"\*_\*") or strmatch(string,"\*\*") or strmatch(string,"\*\*") or strmatch(string,"\*\*") or strmatch(string,"\*\*") or strmatch(string,"\*\*") or strmatch(string,"\*\*") or strmatch(string,"\*\*")) and not strmatch(string,"\*\\\*") then
	print(Unquoted,"\nWARNING : Illegal use of special characters. This may cause trouble !"):
 end_if:
end_proc:

char_test_2:=proc(string)
local test;
begin
  if (strmatch(string,"\*_\*") or strmatch(string,"\*\*") or strmatch(string,"\*\*") or strmatch(string,"\*\*") or strmatch(string,"\*\*") or strmatch(string,"\*\*") or strmatch(string,"\*\*") or strmatch(string,"\*\*")) then
	test:=TRUE:
  else
	test:=FALSE:
  end_if:
end_proc:


return_kill:=proc(param)
local h_t,i,z;
begin
 h_t:=text2list(param,["\n"]):
 z:=nops(h_t):
 for i from 1 to z do
        if h_t[i]="\n" then h_t[i]:="" end_if:
 end_for:
 param:="":
 for i from 1 to z do param:=param.h_t[i] end_for:
end_proc:

index_make:=proc(param) 
local h_t,i,z;
begin
 h_t:=text2list(param,["\n"]):
 z:=nops(h_t):
 for i from 1 to z do
        if h_t[i]<>"\n" then h_t[i]:="\\idx{".h_t[i]."}" end_if:
 end_for:
 param:="":
 for i from 1 to z do param:=param.h_t[i] end_for:
end_proc:

make_crossref:=proc(param)
local h_t,i,ii,z,zz,h2,h3,h_t2,t;
begin
 h_t:=text2list(param,["\n"]):
 h_t2:=h_t:
 z:=nops(h_t):
 t:=FALSE:
 for i from 1 to z do
        if h_t[i]="\n" then 
		h_t[i]:=",":
		h_t2[i]:=",":
	else
		if char_test_2(h_t[i]) then
			h2:=text2list(h_t[i],["_"]):
			zz:=nops(h2):
			for ii from 1 to zz do
				if h2[ii]="_" then h2[ii]:="\\_" end_if:
			end_for:
			h3:="":
			for ii from 1 to zz do h3:=h3.h2[ii] end_for: 
		  	h_t[i]:=h3.",".h_t[i]:
			t:=TRUE:
		else
			h_t[i]:=h_t[i].",".h_t[i]:
		end_if:	
	end_if:
 end_for:
 param:="":
 if t=TRUE then
	param:="spec(":
 else
 	param:="(":
 end_if:
 for i from 1 to z do 
	if t=TRUE then
		param:=param.h_t[i]:
	else
		param:=param.h_t2[i]:
	end_if:
 end_for:
end_proc:


none:=proc()
begin
 if choose="2" then 
	instring:=instring.par_name:
	fullstring:=fullstring.instring:
 else
	instring:=" \\Opt{".instring.par_name." }":
	fullstring:=fullstring.instring:
 end_if:
end_proc:

list:=proc()
begin
  if choose="2" then
	instring:=instring." [ ".par_name." ]":
	fullstring:=fullstring.instring:
  else
	instring:=" \\Opt{".instring." [ ".par_name." ]}":
	fullstring:=fullstring.instring:
 end_if:
end_proc:

sequence:=proc()
begin
  if choose="2" then
	instring:=instring." ".par_name." \\Seq ":
	fullstring:=fullstring.instring:
  else
	instring:=" \\Opt{".instring.par_name." \\Seq }":
	fullstring:=fullstring.instring:
  end_if:
end_proc:

both:=proc()
begin
  if choose="2" then
	instring:=instring." [ ".par_name." \\Seq ]":
	fullstring:=fullstring.instring:
  else
	instring:=" \\Opt{".instring." [ ".par_name." \\Seq ]}":
	fullstring:=fullstring.instring:
  end_if:
end_proc:

meta:=proc()
begin
  meta_nr:=meta_nr+1:
  if choose="2" then
	instring:=instring." {\\sl ".par_name."}":
	fullstring:=fullstring.instring:
  else
	instring:=" \\Opt{".instring." {\\sl ".par_name."}}":
	fullstring:=fullstring.instring:
  end_if:
  meta[meta_nr]:=par_name:
end_proc:

meta_out:=proc() 
local i;
begin
  if meta_nr<>0 then
	fullstring:=fullstring."\\begin{tabular}{lll}\n":
	for i from 1 to meta_nr do
	  repeat
		fullstring:=fullstring."{\\sl ".meta[i]."} &  $\\longrightarrow$ & {\\Mout ":
		print(Unquoted,"\nEnter derivation for '".meta[i]."'\n"):
		text:=input():
		fullstring:=fullstring.text."} \\\\\n":
	  	print(Unquoted,"\nAnother derivation (y/n) ?\n"):
		yesno:=input():
	  until yesno="N" or yesno="n"
	  end_repeat:
	end_for:
	fullstring:=fullstring."\\end{tabular}":
  end_if:
  fullstring:=fullstring."}\n":
end_proc:

print(Unquoted,"\nEnter name:"):
f_name:=input():
spec_char_test():
f_name:=return_kill(f_name):
alt_f_name:=return_kill(alt_f_name):

if spec_char then
	fullstring:=fullstring."\\def\\gegenstand{{\\Mout ".alt_f_name."}}":
 	fullstring:=fullstring."\n\\def\\gegenstandx{".alt_f_name."}\n\n"
 else
	fullstring:=fullstring."\\def\\gegenstand{{\\Mout ".f_name."}}":
 	fullstring:=fullstring."\n\\def\\gegenstandx{".f_name."}\n\n"
end_if:

repeat
  print(Unquoted,"\nCharacter:\n  1 - system/environment variable\n  2 - system function\n  3 - other\n"):
  choose:=input():
until choose="1" or choose="2" or choose="3"
end_repeat:

if not spec_char then
  case choose
	of "1" do fullstring:=fullstring."\\mupsysvar\n":break:
	of "2" do fullstring:=fullstring."\\mupsysfunc\n":break:
        of "3" do fullstring:=fullstring."\\mupfunction\n" 
  end_case:
  print(Unquoted,"\nShort description:\n"):
  short_desc:=input():
  warning(short_desc):
  if choose<>"3" then
        fullstring:=fullstring."{\\gegenstandx}{".short_desc."}{".f_name."}":
  else
        fullstring:=fullstring."{dummy}{".alt_f_name."}{".short_desc."}{".f_name."}":
        print(Unquoted,"\nWARNING: Old function. Problems may occur !\n"):
  end_if:
 else
  case choose
        of "1" do fullstring:=fullstring."\\mupsysvarspec\n":break:
        of "2" do fullstring:=fullstring."\\mupsysfuncspec\n":break:
        of "3" do fullstring:=fullstring."\\mupfunctionspec\n"
  end_case:
  print(Unquoted,"\nShort description:\n"):
  short_desc:=input():
  warning(short_desc):
  if choose<>"3" then
        fullstring:=fullstring."{\\gegenstandx}{".short_desc."}{".f_name."}{".alt_f_name."}":
  else
        fullstring:=fullstring."{dummy}{".alt_f_name."}{".short_desc."}{".f_name."}":
        print(Unquoted,"\nWARNING: Old function. Problems may occur !\n"):
  end_if: 
end_if:

print(Unquoted,"\nKeywords for the index:\n (use <Return> for separation and <Ctrl-D> (terminal version)\n or <Button> (interface version) for completion)\n"):
index:=input():
index:=index_make(index):
fullstring:=fullstring."\n".index."\n\n\\clearbuttons":
fullstring:=fullstring."\n\n\\Mrefstandard\\nodepageref{chap-interfaces}{\\Mpchap}\\nodepageref{app-tables}{\\Mnapp}\n":

print(Unquoted,"\nShall there be a HyTeX button in the headline (y/n) ?\n"):
repeat
	yesno:=input():
until yesno="Y" or yesno="y" or yesno="N" or yesno="n"
end_repeat:
if yesno="Y" or yesno="y" then
	print(Unquoted,"\nEnter the internal node reference:\n"):
	nodename:=input():
	print(Unquoted,"\nEnter the button text:\n"):
	button_label:=input():
	fullstring:=fullstring."\\nodepageref{".nodename."}{".button_label."}\n":
end_if:

print(Unquoted,"\nEnter calling sequence:"):
print(Unquoted,"Enter parameters:"):
meta_nr:=0:
fullstring:=fullstring."\\mupmanfield{\\mcalseq}\n{":
number:=0:
repeat  
     fullstring:=fullstring."\\gegenstand{\\Mout (":
     repeat
		if number<>0 then 
			print(Unquoted,"\nNext parameter\n"):
		end_if:
		print(Unquoted,"  empty			1"):
		print(Unquoted,"  compelling		2"):
		print(Unquoted,"  optional		3"):
		print(Unquoted,"  end (of line)	0\n"):
        repeat
			choose:=input():
		until choose="1" or choose="2" or choose="3" or choose="0"
	end_repeat:
	if choose="2" or choose="3" then
		instring:="":
		if number<>0 then 
			instring:=",":
		end_if:
		print(Unquoted,"\nEnter parameter name:"):
		par_name:=input():
		warning(par_name):
		print(Unquoted,"\nFurther characteristics of parameter '".par_name."' ?"):
		print(Unquoted,"none             0"):
		print(Unquoted,"list             1"):
		print(Unquoted,"sequence         2"):	
		print(Unquoted,"sequence & list  3"):
		print(Unquoted,"meta character   4\n"):
		repeat
       			choose_1:=input():
		until choose_1="1" or choose_1="2" or choose_1="3" or choose_1="4" or choose_1="0"
		end_repeat:
		case choose_1
			of "0" do none():break:
			of "1" do list():break:	
			of "2" do sequence():break:
			of "3" do both():break:
			of "4" do meta():
		end_case:
	end_if:
	if choose="1" or choose="0" then
		fullstring:=fullstring.")} \\\\\n":
	end_if:
      number:=number+1:
      until choose="0" or choose="1"
      end_repeat:
      print(Unquoted,"\nAnother calling sequence (y/n) ?\n"):
      yesno:=input():
until yesno="N" or yesno="n"
end_repeat:
meta_out():
fullstring:=fullstring."\\mupmanfield{Parameter}\n{\\vorruecken\n\\begin{tabular}{lll}\n":
print(Unquoted,"\n\nEnter parameter description:"):
count:=0:
repeat
  print(Unquoted,"Enter parameter name ('0'=end):\n"):
  text:=input():
  warning(text):
  if text<>"0" then
	count:=count+1:
	print(Unquoted,"\nDescription of parameter '".text."' \n"):
	text2:=input():
	warning(text2):
	fullstring:=fullstring."{\\Mout ".text."}&---& ".text2." \\\\\n":
  end_if:
until text="0"
end_repeat:
if count=0 then 
	fullstring:=fullstring."none \\\\\n":
end_if:
fullstring:=fullstring."\\end{tabular}\n}\n\n":

fullstring:=fullstring."\\mupsummary{\n":
repeat
  print(Unquoted,"\nEnter summary of functionality:"):
  print(Unquoted,"(This text will be included on the help page. TeX code is allowed.)\n"):
  summary:=input():
  warning(summary):
  if summary="" then
	print(Unquoted,"\nEmpty description is not allowed !\n"):
  end_if:
until summary<>""
end_repeat:
fullstring:=fullstring.summary."\n}\n\n":

print(Unquoted,"\n\nEnter examples:"):
print(Unquoted,"(use correct MuPAD syntax !)\n"):
repeat
  print(Unquoted,"Input ('0'=end):\n"):
  text:=input():
  if text<>"0" or text="" then 
	print(Unquoted,"output ('0'=no output):\n"):
	text2:=input():
	fullstring:=fullstring."\\begin{vin}".text."\n\\end{vin}\n":
	if text2<>"0" or text2="" then
		fullstring:=fullstring."\\begin{vout}".text2."\n\\end{vout}\n":
	end_if:
  end_if:
until text="0"
end_repeat:
fullstring:=fullstring."\n\n\\mupseealso":
print(Unquoted,"\nReferences to related functions:\nOne entry per line, use <Return> for separating, use <Ctrl-D>\n(terminal version) or <Done Button> (interface version) for completion.");
print(Unquoted,"Enter '0' for no references !\n"):
text:=input():
if text<>"0" then
	text:=make_crossref(text):
	fullstring:=fullstring.text.")":
else
	fullstring:=fullstring."()":
end_if:
fullstring:=fullstring."\n\\ownend{document}\n":

print(Unquoted,"\nShall '".f_name."' be used as file name (y/n) ?\n"):
yesno:=input():
if yesno="y" or yesno="Y" then
	fprint(Unquoted,Text,f_name.".tex",fullstring):
else
	print(Unquoted,"\nEnter file name !"):
	text:=input():
	fprint(Unquoted,Text,text,fullstring):
end_if:
	
end_proc:  # main #

