# $Date: 1995/06/08 11:17:43 $ $Author: frankp $ $Revision: 1.7 $ #

# kg, 13/01/94 #

#++
asinh -- the inverse hyperbolic sine

asinh(x)

x - expression
++#

asinh:= proc(x)
    local f;
    name asinh;
begin
    if x::asinh <> FAIL then return(x::asinh(args())) end_if;
    if args(0) <> 1 then error("wrong no of args") end_if;

    case type(x)
    of DOM_INT do
    of DOM_RAT do
	if x < 0 then return(-asinh(-x)) end_if;
	break;
    
    of DOM_FLOAT do
	return(funcattr(asinh,"float")(x));

    of DOM_COMPLEX do
	if domtype(op(x,1)) = DOM_FLOAT or
	   domtype(op(x,2)) = DOM_FLOAT then
	    return(funcattr(asinh,"float")(x))
	end_if;
	break;

    of "_mult" do
	f:= op(x, nops(x));
	if testtype(f, Type::RealNum) then
	    if f < 0 then return(-asinh(-x)) end_if;
	end_if;
	break;

    end_case;

    procname(x)
end_proc:

asinh:= funcattr(asinh, "print", "asinh"):

asinh:= funcattr(asinh, "diff", proc(e)
    local i;
begin
    e:= op(e,1); diff(e, args(i) $ i=2..args(0)) / sqrt(e^2+1)
end_proc):

Series::gen["asinh"]:=proc(n) local a,i;
begin
   a:=1;
   [a,(0,(a:=-a*(2*i-1)/2/i)/(2*i+1))$i=1..(n div 2)-1]
end_proc:
Series::gen["asinh"](0):=[]:
Series::gen["asinh"](1):=[]:

asinh:=funcattr(asinh,"series",
proc(f, x, n)
begin
   # formula 4.6.20 of Abramowitz & Stegun #
   Series::Puiseux(ln(f+sqrt(f^2+1)),x,n)
end_proc):

asinh:= funcattr(asinh,"info","asinh -- the inverse hyperbolic sine"):

asinh(0):= 0:

# end of file #
