# $Date: 1995/06/08 11:17:48 $ $Author: frankp $ $Revision: 1.12 $ #

# kg, 13/01/94 #

#++
cot -- the cotangens

cot(x)

x - expression
++#

cot:= subsop(tan, [2,4]="cot", 1=proc(x)
    local f;
    name cot;
begin
    if x::cot <> FAIL then return(x::cot(args())) end_if;
    if args(0) <> 1 then error("wrong no of args") end_if;

    if x = 0 or x = PI then error("singularity") end_if;

    case type(x)
    of DOM_INT do
    of DOM_RAT do
	if x < 0 then return(-cot(-x)) end_if;
	break;
    
    of DOM_FLOAT do
	return(funcattr(cos,"float")(x)/funcattr(sin,"float")(x));


    of DOM_COMPLEX do
	if domtype(op(x,1)) = DOM_FLOAT or
           domtype(op(x,2)) = DOM_FLOAT then
	       return(funcattr(cos,"float")(x)/funcattr(sin,"float")(x));
	   end_if;
	if op(x,1) = 0 then return(-coth(-x*I)*I) end_if;
	break;

    of "_mult" do
	f:= op(x, nops(x));
	if testtype(f, Type::RealNum) then
	    if f < 0 then return(-cot(-x)) end_if;
	    if domtype(f) = DOM_FLOAT then break end_if;
	else
	    break
	end_if;

	if nops(x) = 2 then
	    if op(x,1) = PI then
		if f = 0 then error("singularity") end_if;
		if f < 1/2 then break end_if;
		if f < 1 then return(-cot((1-f)*PI)) end_if;
		if f = 1 then error("singularity") end_if;
		if f < 2 then return(cot((f-1)*PI)) end_if;
		return(cot((f-2*(floor(f) div 2))*PI));
	    end_if
	end_if;
	break;

    of "asin" do return(sqrt(1-op(x)^2) / op(x));
    of "acos" do return(op(x) / sqrt(1-op(x)^2));
    of "atan" do return(1/op(x));
    of "acot" do return(op(x));
    end_case;

    procname(x)
end_proc):

cot:= funcattr(cot, "type", "cot"):
cot:= funcattr(cot, "print", "cot"):

cot:= funcattr(cot, "float", proc(e)
   name cot;
begin
   # cot(e) = cos(e)/sin(e) #

   funcattr(sin,"float")(e);
   if % = 0.0 then
      error("singularity")
   else funcattr(cos,"float")(e)/%
   end_if
end_proc):

cot:= funcattr(cot, "diff", proc(e)
    local i;
begin
    e:= op(e,1); - diff(e, args(i) $ i=2..args(0)) / sin(e)^2
end_proc):

cot:= funcattr(cot, "expand", fun(expand(cos(args(1))/sin(args(1)))) ):

cot:= funcattr( cot, "conjugate", fun((
    conjugate(args(1));
    if type(%) = "conjugate" then hold(cot)(%)
    else cot(%)
    end_if
)) ):

cot:= funcattr( cot, "info", "cot -- the cotangent" ):

cot(PI/12):= 2+3^(1/2):
cot(PI/8):= 2^(1/2)+1:
cot(PI/6):= (3^(1/2)):
cot(PI/4):= 1:
cot(PI/3):= (3^(1/2))/3:
cot(3*PI/8):= 2^(1/2)-1:
cot(5*PI/12):= 2-3^(1/2):
cot(PI/2):= 0:
cot(I):= - coth(1)*I:

# end of file #
