
# ok, 27/01/94 #

#++
coth -- the hyperbolic cotangens

coth(x)

x - expression
++#

coth:= proc(x)
    local f;
    name coth;
begin
    if x::coth <> FAIL then return(x::coth(args())) end_if;
    if args(0) <> 1 then error("wrong no of args") end_if;

    case type(x)
    of DOM_INT do
    of DOM_RAT do
        if x = 0 then
           error("singularity")
	elif x < 0 then 
           return(-coth(-x)) end_if;
	break;
    
    of DOM_FLOAT do
	return(funcattr(coth,"float")(x));

    of DOM_COMPLEX do
	if domtype(op(x,1)) = DOM_FLOAT or
	   domtype(op(x,2)) = DOM_FLOAT then
	    return(funcattr(coth,"float")(x))
	elif op(x, 1) = 0 then
            return(-I*cot(-I*x))
	elif op(x, 1) < 0 and op(x, 2) < 0 then
            return(-coth(-x))
	end_if;
	break;

    of "_mult" do
	f:= op(x, nops(x));
	if testtype(f, Type::RealNum) then
	    if f < 0 then return(-coth(-x)) end_if;
	end_if;
	break;

    of "acoth" do return(op(x));
    of "asinh" do return(sqrt(op(x)^2+1)/op(x));
    of "acsch" do return(sqrt(op(x)^2+1));
    of "acosh" do return(op(x)/sqrt(op(x)^2-1));
    of "asech" do return(1/sqrt(1-op(x)^2));
    of "atanh" do return(1/op(x));

    end_case;

    procname(x)
end_proc:

coth:= funcattr(coth, "type", "coth"):
coth:= funcattr(coth, "print", "coth"):

coth:= funcattr(coth, "diff", proc(e)
    local i;
begin
    e:= op(e,1); diff(e, args(i) $ i=2..args(0)) * (1-coth(e)^2)
end_proc):

coth:= funcattr(coth, "float", proc(e)
    name coth;
begin
    # coth(e) = 1/tanh(e) #
    if e = 0 or e = 0.0 then
       error("singularity")
    else
       1/funcattr(tanh, "float")(e)
    end_if
end_proc):

coth:= funcattr(coth, "expand", fun(expand(cosh(args(1))/sinh(args(1)))) ):

coth:= funcattr( coth, "conjugate", fun((
    conjugate(args(1));
    if type(%) = "conjugate" then hold(coth)(%)
    else coth(%)
    end_if
)) ):

coth:= funcattr( coth, "info", "coth -- the hyperbolic cotangent"):
# end of file #
