# $Date: 1995/06/08 11:17:51 $ $Author: frankp $ $Revision: 1.9 $ #

# frankp, 4.05.1995 #

#++
   eint.mu

	eint  --  The Exponential Integral
        eint(x) = int(exp(-t)/t,t=x..infinity) [ denoted Ei(1,x) in Maple ]
++#

eint := funcattr(stdlib::eint,"diff",
    proc(x)
    begin
        x := op(x,1);
        if args(0) = 1 then hold(eint)(x)
        elif has(x,args(2)) then
            if args(0) > 2 then
                -diff(exp(-x)/x,args(i) $ hold(i)=3..args(0))
            else
                -exp(-x)/x*diff(x,args(2))
            end_if
        else
            0
        end_if
    end_proc
):

eint:=funcattr(eint,"info","eint -- the exponential integral [try ?eint for details]"):

eint:=funcattr(eint,"series",proc(f,x,n) # series(eint(f),x=0,n) #
name Series::eint;
local s,t,i,k;
begin
   if f=x then # expansion of eint(x) for x = 0 #
     new(gseries,[[-1,ln(x)],[-EULER,1],[(-1)^(i+1)/i/fact(i),x^i]$i=1..n-1],x^n,x)
   else
     t:=Series::series(f,x,n);
     if type(t) = Puiseux then
       k:=t::ldegree(t);
       if k>0 then # f goes to zero #
         t:=series((exp(-f)-1)/f*diff(f,x),x,n);
         if not testtype(t,Type::Series(Taylor)) then
           error("unable to compute series expansion")
         end_if;
         k:=series(ln(f),x,n+k);
         if type(k) <> Puiseux then
           error("unable to compute series expansion")
         end_if;
         Series::series(-EULER-expr(k)-int(expr(t),x),x,n+1) 
       elif k<0 then # f goes to +/-infinity #
         t:=1;
         s:=Puiseux::create(1,1,n+1,[1,(t:=-t*i)$i=1..n-1],x);
         s:=Puiseux::_fconcat(s,Series::series(1/f,x,n));
         s:=gseries::convert(extsubsop(s,5=x));
         gseries::scalmult(s,1,exp(-f))
       else
         Series::unknown(eint(f),x,n)
       end_if
     else
	error("unable to compute series expansion")
     end_if
  end_if
end_proc):

# end of file #

