# ok, 25/01/94 #

#++
The complementary error function

erfc(x)

x - an expression
++#

erfc := proc(x) 
begin
  if x::erfc <> FAIL then return(x::erfc(args())) end_if;
  if args(0) <> 1 then
     error("1 argument expected");
  end_if;
  
  case type(x)

    of DOM_FLOAT do
        return(funcattr(erfc,"float")(x));
    of DOM_INT do
    of DOM_RAT do return((if x<0 then 2-procname(-x) else procname(x) end_if))
    of "_mult" do
        f:= op(x, nops(x));
        if testtype(f, Type::RealNum) then
            if f < 0 then return(2-erfc(-x)) end_if;
            if domtype(f) = DOM_FLOAT then break end_if;
        else
            break
        end_if;

    end_case;
    procname(x) 
end_proc:

erfc(0) := 1:

erfc:= funcattr(erfc, "print", "erfc"):

erfc:= funcattr( erfc, "conjugate", fun((
    conjugate(args(1));
    if type(%) = "conjugate" then hold(erfc)(%)
    else erfc(%)
    end_if
)) ):

erfc := funcattr( erfc, "diff", proc(e)
    local i;
begin
    e:= op(e,1); -2/PI^(1/2) * exp(-e^2) * diff(e, args(i) $ i=2..args(0))
end_proc):

erfc:= funcattr(erfc,"info","erfc -- the complementary error function [try ?erf for details]"):

# erf(x) is automatically expanded into 1-erfc(x) #
erfc:=funcattr(erfc,"series",proc(f,x,n)
name Series::erfc;
local t,s;
begin
   t:=Series::series(f,x,n);
   if ldegree(t)<0 then # f goes to +/-infinity #
      s:=sign(lcoeff(t));
      if s=1 then # +infinity #
         s:=Puiseux::create(1,1,n+1,Series::gen["erfc"](n),x);
         s:=Puiseux::_fconcat(s,Series::series(1/f,x,n));
         s:=gseries::convert(extsubsop(s,5=x));
         gseries::scalmult(s,1,exp(-f^2))
      elif s=-1 then # -infinity #
         s:=Puiseux::create(1,1,n+1,Series::gen["erfc"](n),x);
         s:=Puiseux::_fconcat(s,Series::series(-1/f,x,n));
         s:=gseries::convert(extsubsop(s,5=x));
         -1+gseries::scalmult(s,1,exp(-f^2))
      else error("unable to compute expansion")
      end_if
   else Series::unknown(erfc(f),x,n)
   end_if
end_proc):

# end of file #
