# $Date: 1995/07/14 10:18:04 $ $Author: kg $ $Revision: 1.15.2.1 $ #

# kg, 13/01/94 #

#++
sin -- the sine

sin(x)

x - expression
++#

sin:= proc(x)
    local f;
    name sin;
begin
    if x::sin <> FAIL then return(x::sin(args())) end_if;

    if args(0) <> 1 then error("wrong no of args") end_if;

    case type(x)
    of DOM_INT do
    of DOM_RAT do
	if x < 0 then return(-sin(-x)) end_if;
	break;

    of DOM_FLOAT do
	return(funcattr(sin,"float")(x));

    of DOM_COMPLEX do
        if domtype(op(x,1)) = DOM_FLOAT or
           domtype(op(x,2)) = DOM_FLOAT then
	       return(funcattr(sin,"float")(x))
	   end_if;
	if op(x,1) = 0 then return(sinh(-x*I)*I) end_if;
	break;

    of "_mult" do
	f:= op(x, nops(x));
	if testtype(f, Type::RealNum) then
	    if f < 0 then return(-sin(-x)) end_if;
	    if domtype(f) = DOM_FLOAT then break end_if;
	else
	    break
	end_if;

	if nops(x) = 2 then
	    if op(x,1) = PI then
		if f < 1/2 then break end_if;
		if f < 1 then return(sin((1-f)*PI)) end_if;
		if f < 2 then return(-sin((2-f)*PI)) end_if;
		return(sin((f-2*(floor(f) div 2))*PI));
	    end_if
	end_if;
	break;

    of "asin" do return(op(x));
    of "acos" do return(sqrt(1-op(x)^2));
    of "atan" do return(op(x)/sqrt(1+op(x)^2));
    end_case;

    procname(x)
end_proc:

sin:= funcattr(sin, "print", "sin"):

sin(0):= 0:
sin(PI/12):= (6^(1/2)-2^(1/2))/4: # simpler than ((2-3^(1/2))^(1/2))/2: #
sin(PI/8):= ((2-2^(1/2))^(1/2))/2:
sin(PI/6):= 1/2:
sin(PI/4):= (2^(1/2))/2:
sin(PI/3):= (3^(1/2))/2:
sin(3*PI/8):= ((2+2^(1/2))^(1/2))/2:
sin(5*PI/12):= ((2+3^(1/2))^(1/2))/2:
sin(PI/2):= 1:
sin(PI):= 0:
sin(I):= sinh(1)*I:

# sin(-x)     = -sin(x)                                                 #
# sin(x +- y) = sin(x) * cos(y) +- sin(y) * cos(x)                      #
#               n/2                                                     #
#               ---                                                     #
#               \   (   n  )                                            #
# sin(n * x)  = /   ( 2*i+1) cos(x)^(n-2*i-1)*sin(x)^(2*i+1)*(-1)^(i+1) #
#               ---                                                     #
#               i=0                                                     #



sin := funcattr(sin, "expand", proc(x)
  local n, t, y;
begin
  y := expand(x);

  case type(y)

    of "_plus" do

       n := op(y, 1); y := subsop(y, 1=null());
       return(expand(sin(n)*cos(y)+cos(n)*sin(y)));

    of "_mult" do

       n := op(y, nops(y)); t := type(n);
       if t = DOM_INT or t = DOM_RAT then
          if n < 0 then
             return(expand(-sin(-y)));
          elif t = DOM_INT and n > 0 then
             y := y / n;
             return(expand(2*sin((n-1)*y)*cos(y)-sin((n-2)*y)));
          end_if
       end_if
 
  end_case;
 
  sin(y)
 
end_proc):

sin:= funcattr( sin, "conjugate", fun((
    conjugate(args(1));
    if type(%) = "conjugate" then hold(sin)(%)
    else sin(%)
    end_if
)) ):

sin:= funcattr( sin, "info", "sin -- the sine" ):

# end of file #
