#
   stdev(l) - standard deviation over the full population, i.e. sqrt(variance(l))
   stdev(l,Sample) - standard deviation over a sample, i.e. sqrt(n(variance(l)/(n-1)))
#

stats::stdev:=proc(l,opt) local n;
begin 
   if opt=hold(Sample) then
      n:=nops(l); sqrt(n*stats::variance(l)/(n-1))
   else sqrt(stats::variance(l)) 
   end_if
end_proc:
