# $Date: 1994/08/01 09:38:50 $  $Author: kg $  $Revision: 1.4 $ #

# kg, 29/06/93 #

#++
Poly -- creates a domain of kernel polynomials

Poly(X [, R])

X - list of indeterminates
R - (optional) coeffizient ring 'Expr', 'IntMod(n)' or domain,
    default is 'Expr'

Poly creates a domain of MuPAD kernel polynomials (CAT_POLY) with
indeterminates 'X' over the coefficient ring 'R'. If no ring is
given, 'Expr' is choosen as ring.

The main application of a domain created by Poly is the recursive
representation of polynomials: A domain created by Poly may be used
as a coefficient ring for kernel polynomials. Expressions like

	poly(x*y, [x], Poly([y]))

may be used to define polynomials which have kernel polynomials as
coeffizients, giving rise to a recursive representation of polynomials.
(The internal representation of kernel polynomials is a distributive
one.)
++#

Poly:= proc(X, R)
    local D;
    option remember;
begin
    if args(0) = 1 then
	R:= hold(Expr)
    elif testargs() then
	if args(0) < 1 or args(0) > 2 then
	    error("wrong no of args")
	end_if;
    end_if;

    D:= domain();
    D::name:= hold(Poly)(X,R);

    if domtype(R) = DOM_DOMAIN then
	D::zero:= poly(R::zero, X, R);
	D::one:= poly(R::one, X, R)
    else
	D::zero:= poly(0, X, R);
	D::one:= poly(1, X, R)
    end_if;

    D::_plus:= _plus;
    D::_mult:= _mult;
    D::_power:= _power;
    D::negate:= - id;
    D::norm:= norm;
    D::divex:= fun(divide(args(1), args(2), hold(Exact)));
    D::diff:= diff;
    D::intmult:= multcoeffs;
    D::expr:= expr;
    D::gcd:= gcd;
    D::convert:= eval(subs(hold(fun(poly(args(1), hold(X), R))),
			hold(X)=X, hold(R)=R, Unsimplified));
    D
end_proc:

