RootOf:=domain():
RootOf::name:="RootOf":

RootOf::new := proc(eq,z)
begin
   if args(0)=1 then
      z:=indets(eq);
      if nops(z)<>1 then error("you should specify the RootOf variable") end_if;
      z:=op(z)
   end_if;
   if type(eq)=DOM_POLY then eq:=expr(eq) end_if;
   eq:=primpart(numer(eq),[z]);
   new(RootOf,eq,z)
end_proc:

RootOf::print := proc(a)
begin
   if indets(extop(a,1),PolyExpr)={extop(a,2)} then hold(RootOf)(extop(a,1))
   else hold(RootOf)(extop(a))
   end_if
end_proc:

# normalizes the fraction f in x, where x=RootOf(p) #
RootOf::evala := proc(f,p,_x)
local l;
begin
   userinfo(1,"f=",f,"p=",p,"x=",_x);
   l:=gcdex(denom(f),p,_x); 
   # l[1]=denom(f)*l[2]+p*l[3] thus 1/denom(f) = l[2]/l[1] mod p #
   if has(l[1],_x) then error("singular denominator") end_if;
   numer(f)*l[2]/l[1]
end_proc:

# computes the sum of the terms in f, where x goes through the roots of p #
RootOf::polysum := proc(f,p,x)
local d,y;
begin
   f:=divide(f,p,[x],Rem);
   d:=degree(p,[x]);
   if not has(f,x) then d*f
   else
      f:=resultant(p,numer(y-f),x);
      normal(-coeff(f,[y],d-1)/coeff(f,[y],d))
   end_if
end_proc:

