# $Date: 1995/06/22 14:51:43 $ $Author: kg $ $Revision: 1.5.2.1 $ #

# kg, 13/01/95 #

#++
alias -- define alias name

alias(abbr=expr,...)

abbr - identifier or function call where the operands must be identifiers
expr - expression

An alias is an expression which is changed by the parser into another
one before evaluating the parsed expression. An alias may be defined
either for identifiers or for function calls:

- With an alias of the form alias(a=b) every a parsed is changed into b.

- With an alias of the form alias(f(x...)=z) every call f(a...) parsed is 
  replaced by subs(z, [x=a...]), ie. f(a...) is replaced by z, whereby the
  'formal parameters' x... of f are replaced by the 'actual parameters' a...

alias doesn't evaluate its arguments.
++#

alias:= proc()
    local _0_arg;
    option hold;
begin
    if testargs() then
	if args(0) = 0 then error("no args") end_if;
	for _0_arg in [ args() ] do
	    if domtype(op(_0_arg, 1)) <> DOM_IDENT then
		if domtype(op(_0_arg, 1)) = DOM_EXPR then
		    if nops(op(_0_arg, 1)) <> 0 then
			if {map(op(op(_0_arg, 1)), domtype)} <> {DOM_IDENT} then
			    error("illegal parameter(s)")
			end_if
		    end_if;
		    if type(op(_0_arg, 2)) = "_exprseq" then
			error("illegal alias value")
		    end_if
		else
		    error("illegal alias name")
		end_if
	    end_if
	end_for
    end_if;

    # create tables for alias entries
    
       - stdlib::Alias[1][a] is the alias value of identifier a.
       - stdlib::Alias[2][v] is the identifier associated to value v, needed
            to unalias a (when unalias(a) is called a is replaced by v before
            evaluation, so one must use v to get back a again).
       - stdlib::Alias[3][a] is the alias value of operator a, consisting of
            the associated expression and the formal parameters.
    #
    if stdlib::Alias = FAIL then
        stdlib::Alias:= [ table(), table(), table() ];
    end_if;
   
    # assign alias function to parser #
    if domtype(_dom_alias_element_) = DOM_IDENT then
     	_dom_alias_element_:= fun((
	    case domtype(args(1))
	    of DOM_IDENT do
		if contains(stdlib::Alias[1], args(1)) then
		    index_val(stdlib::Alias[1], args(1))
		else
		    args(1)
		end_if;
		break;
	    of DOM_EXPR do
		if contains(stdlib::Alias[3], op(args(1),0)) then
		    index_val(stdlib::Alias[3], op(args(1),0));
		    subs(%[1], zip(%[2], [op(args(1))], _equal), Unsimplified)
		else
		    args(1)
		end_if;
		break;
	    otherwise
		args(1)
	    end_case))
    end_if;
    
    # insert new alias #
    for _0_arg in [ args() ] do
	case domtype(op(_0_arg, 1))
	of DOM_IDENT do
	    stdlib::Alias[1][op(_0_arg, 1)]:= op(_0_arg, 2);
	    stdlib::Alias[2][op(_0_arg, 2)]:= op(_0_arg, 1);
	    break;
	of DOM_EXPR do
	    stdlib::Alias[3][op(op(_0_arg, 1), 0)]:= [op(_0_arg, 2), [op(op(_0_arg, 1))]];
	    break;
	otherwise error("illegal alias name")
	end_case;
    end_for;
    null()
end_proc:

# end of file #
