
# ok, 21/01/94 #

#++
Bernoulli numbers and polynomials

bernoulli(n)
bernoulli(n, x)

n - a non-negative integer
x - an expression
++#

bernoulli := proc(n, x)

   option remember;

   local a, b, i, X;

begin

  case args(0)

    of 1 do

       if testtype(n, NUMERIC) then

          if domtype(n) = DOM_INT and n >= 0 then
             if n mod 2 <> 0 then 
                return( 0 )
             else
                a := 1;
                b := 1/2-1/2*n;
                for i from 2 to n-2 step 2 do
                    a :=  (a * (n+3-i) * (n+2-i)) div ((i-1)*i);
                    b := b + a * bernoulli(i)
                end_for; 
                return( -b / (n+1) )
              end_if
           else    
              error("first argument must be a nonnegative integer")
           end_if

	end_if;

        return( procname(n) );

    of 2 do

	if x = 0 or x = 1 then 
           bernoulli(n)
        elif x = 1/2 then 
           (2^(1-n)-1)*bernoulli(n)
        elif domtype(n) = DOM_INT then
	   if n < 0 then
              error("first argument must be a nonnegative integer")
           end_if;
           if n = 0 then 
              1
           elif n = 1 then 
              x-1/2
           else
              bernoulli(n) + n *
              subs( map(
                        bernoulli(n-1, X),
                        proc(a) begin a * X / ( degree(a, [X]) + 1) end_proc
                       ),
                   X = x
               )
           end_if
        elif domtype(x) = DOM_RAT and x < 0 then
            (-1)^n*bernoulli(n,-x)+(-1)^n*n*(-x)^(n-1)
        else 
            procname(n, x)
        end_if;

	break;

    otherwise

      error("1 or 2 arguments expected.")

  end_case

end_proc:

bernoulli(0) := 1: bernoulli(1) := -1/2:

bernoulli:= funcattr(bernoulli, "type", "bernoulli"):
bernoulli:= funcattr(bernoulli, "print", "bernoulli"):
