binomial := proc(n, k)

   local b, i;
   name binomial;

begin

    if args(0) <> 2 then
       error("2 arguments expected")
    end_if;

    if k = 0 or k = n then    # (1) #
       return( 1 )
    elif k = 1 or k = n-1 then
       return( n )
    end_if;

    if not testtype(n, NUMERIC) or not testtype(k, NUMERIC) then
       return( procname(n, k) )
    end_if;

    case domtype(k)

      of DOM_INT do

       case domtype(n)

         of DOM_INT do

            if k < 0 then
               if 0 <= n then 
                  return( 0 )
               elif n-k < 0 then 
                  return( 0 )
               else 
                  return( binomial(n, n-k) )
               end_if
            else # k > 0, see (1) #
               if n < 0 then 
                  return( (-1)^k*binomial(k-n-1, k) )
               elif n-k < k then 
                  return( binomial(n, n-k) )
               end_if
            end_if;
	    break;

         of DOM_RAT     do
         of DOM_FLOAT   do
         of DOM_COMPLEX do

            if k < 0 then 
               return( 0 )
            end_if;
	    break;

       end_case;

       b := n;   
       for i from k downto 2 do  
           b := b * (n+i-k-1)/i
       end_for;

       break;

     of DOM_RAT do

        case domtype(n)

	  of DOM_FLOAT do

	     return( gamma(n+1)/gamma(float(k)+1)/gamma(n-k+1) );

          of DOM_COMPLEX do

             if domtype(op(n,1)) = DOM_FLOAT 
                or domtype(op(n,2)) = DOM_FLOAT then
		return( gamma(n+1)/gamma(float(k)+1)/gamma(n-k+1) )
             end_if;

	end_case;

	procname(n, k); break;

	  
     of DOM_FLOAT do
       
        gamma(float(n)+1)/gamma(k+1)/gamma(n-k+1);
	break;

     of DOM_COMPLEX do

        if domtype(k) = DOM_FLOAT or 
           domtype(op(n,1)) = DOM_FLOAT or
           domtype(op(n,2)) = DOM_FLOAT then
           gamma(float(n+1))/gamma(float(k+1))/gamma(float(n-k+1))
	else
           procname(n, k);
	end_if;

	break;

   end_case

end_proc:

binomial := funcattr(binomial, "type", "binomial"):
binomial := funcattr(binomial, "print", "binomial"):

binomial := funcattr(binomial, "float", 
                     proc(n, k) begin binomial(float(n), float(k)) end_proc
                    ):

binomial := funcattr(binomial,"expand",
   proc(n,k) 
   begin 
      if testtype(k,Type::NegInt) or testtype(n-k,Type::NegInt) then 0
      else expand(fact(n)/fact(k)/fact(n-k))
      end_if
   end_proc):

binomial := funcattr(binomial,"simplify",
   proc(n,k) 
   begin 
      if testtype(k,Type::NegInt) or testtype(n-k,Type::NegInt) then 0
      else hold(binomial)(n,k)
      end_if
   end_proc):

binomial := funcattr(binomial,"series",
proc(f,g,x,n) begin Series::series(gamma(f+1)/gamma(g+1)/gamma(f-g+1),x,n) end_proc):
